/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.internal.UserAgentUtils;
import software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest;
import software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse;
import software.amazon.awssdk.services.emr.model.SessionMappingSummary;

public class ListStudioSessionMappingsIterable
implements SdkIterable<ListStudioSessionMappingsResponse> {
    private final EmrClient client;
    private final ListStudioSessionMappingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStudioSessionMappingsIterable(EmrClient client, ListStudioSessionMappingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStudioSessionMappingsResponseFetcher();
    }

    public Iterator<ListStudioSessionMappingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SessionMappingSummary> sessionMappings() {
        Function<ListStudioSessionMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionMappings() != null) {
                return response.sessionMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStudioSessionMappingsResponseFetcher
    implements SyncPageFetcher<ListStudioSessionMappingsResponse> {
        private ListStudioSessionMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListStudioSessionMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListStudioSessionMappingsResponse nextPage(ListStudioSessionMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListStudioSessionMappingsIterable.this.client.listStudioSessionMappings(ListStudioSessionMappingsIterable.this.firstRequest);
            }
            return ListStudioSessionMappingsIterable.this.client.listStudioSessionMappings((ListStudioSessionMappingsRequest)((Object)ListStudioSessionMappingsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

