/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceRoleType {
    MASTER("MASTER"),
    CORE("CORE"),
    TASK("TASK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceRoleType> VALUE_MAP;
    private final String value;

    private InstanceRoleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceRoleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceRoleType> knownValues() {
        EnumSet<InstanceRoleType> knownValues = EnumSet.allOf(InstanceRoleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceRoleType.class, InstanceRoleType::toString);
    }
}

