/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest;
import software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse;

public class ListReleaseLabelsPublisher
implements SdkPublisher<ListReleaseLabelsResponse> {
    private final EmrAsyncClient client;
    private final ListReleaseLabelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReleaseLabelsPublisher(EmrAsyncClient client, ListReleaseLabelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReleaseLabelsPublisher(EmrAsyncClient client, ListReleaseLabelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReleaseLabelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReleaseLabelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListReleaseLabelsResponseFetcher
    implements AsyncPageFetcher<ListReleaseLabelsResponse> {
        private ListReleaseLabelsResponseFetcher() {
        }

        public boolean hasNextPage(ListReleaseLabelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReleaseLabelsResponse> nextPage(ListReleaseLabelsResponse previousPage) {
            if (previousPage == null) {
                return ListReleaseLabelsPublisher.this.client.listReleaseLabels(ListReleaseLabelsPublisher.this.firstRequest);
            }
            return ListReleaseLabelsPublisher.this.client.listReleaseLabels((ListReleaseLabelsRequest)((Object)ListReleaseLabelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

