/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A tuple that provides information about an error that caused a cluster to terminate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorDetail implements SdkPojo, Serializable, ToCopyableBuilder<ErrorDetail.Builder, ErrorDetail> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(ErrorDetail::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<List<Map<String, String>>> ERROR_DATA_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("ErrorData")
            .getter(getter(ErrorDetail::errorData))
            .setter(setter(Builder::errorData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(ErrorDetail::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_DATA_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final List<Map<String, String>> errorData;

    private final String errorMessage;

    private ErrorDetail(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorData = builder.errorData;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The name or code associated with the error.
     * </p>
     * 
     * @return The name or code associated with the error.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorData property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrorData() {
        return errorData != null && !(errorData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key value pairs that provides contextual information about why an error occured.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorData} method.
     * </p>
     * 
     * @return A list of key value pairs that provides contextual information about why an error occured.
     */
    public final List<Map<String, String>> errorData() {
        return errorData;
    }

    /**
     * <p>
     * A message that describes the error.
     * </p>
     * 
     * @return A message that describes the error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorData() ? errorData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorDetail)) {
            return false;
        }
        ErrorDetail other = (ErrorDetail) obj;
        return Objects.equals(errorCode(), other.errorCode()) && hasErrorData() == other.hasErrorData()
                && Objects.equals(errorData(), other.errorData()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorDetail").add("ErrorCode", errorCode())
                .add("ErrorData", hasErrorData() ? errorData() : null).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorData":
            return Optional.ofNullable(clazz.cast(errorData()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorDetail, T> g) {
        return obj -> g.apply((ErrorDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorDetail> {
        /**
         * <p>
         * The name or code associated with the error.
         * </p>
         * 
         * @param errorCode
         *        The name or code associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A list of key value pairs that provides contextual information about why an error occured.
         * </p>
         * 
         * @param errorData
         *        A list of key value pairs that provides contextual information about why an error occured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorData(Collection<? extends Map<String, String>> errorData);

        /**
         * <p>
         * A list of key value pairs that provides contextual information about why an error occured.
         * </p>
         * 
         * @param errorData
         *        A list of key value pairs that provides contextual information about why an error occured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorData(Map<String, String>... errorData);

        /**
         * <p>
         * A message that describes the error.
         * </p>
         * 
         * @param errorMessage
         *        A message that describes the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private List<Map<String, String>> errorData = DefaultSdkAutoConstructList.getInstance();

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorDetail model) {
            errorCode(model.errorCode);
            errorData(model.errorData);
            errorMessage(model.errorMessage);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final Collection<? extends Map<String, String>> getErrorData() {
            if (errorData instanceof SdkAutoConstructList) {
                return null;
            }
            return errorData;
        }

        public final void setErrorData(Collection<? extends Map<String, String>> errorData) {
            this.errorData = ErrorDataCopier.copy(errorData);
        }

        @Override
        public final Builder errorData(Collection<? extends Map<String, String>> errorData) {
            this.errorData = ErrorDataCopier.copy(errorData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorData(Map<String, String>... errorData) {
            errorData(Arrays.asList(errorData));
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public ErrorDetail build() {
            return new ErrorDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
