/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotebookExecutionsRequest extends EmrRequest implements
        ToCopyableBuilder<ListNotebookExecutionsRequest.Builder, ListNotebookExecutionsRequest> {
    private static final SdkField<String> EDITOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EditorId").getter(getter(ListNotebookExecutionsRequest::editorId)).setter(setter(Builder::editorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EditorId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListNotebookExecutionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> FROM_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("From")
            .getter(getter(ListNotebookExecutionsRequest::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()).build();

    private static final SdkField<Instant> TO_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("To")
            .getter(getter(ListNotebookExecutionsRequest::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListNotebookExecutionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<String> EXECUTION_ENGINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionEngineId").getter(getter(ListNotebookExecutionsRequest::executionEngineId))
            .setter(setter(Builder::executionEngineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEngineId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITOR_ID_FIELD, STATUS_FIELD,
            FROM_FIELD, TO_FIELD, MARKER_FIELD, EXECUTION_ENGINE_ID_FIELD));

    private final String editorId;

    private final String status;

    private final Instant from;

    private final Instant to;

    private final String marker;

    private final String executionEngineId;

    private ListNotebookExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.editorId = builder.editorId;
        this.status = builder.status;
        this.from = builder.from;
        this.to = builder.to;
        this.marker = builder.marker;
        this.executionEngineId = builder.executionEngineId;
    }

    /**
     * <p>
     * The unique ID of the editor associated with the notebook execution.
     * </p>
     * 
     * @return The unique ID of the editor associated with the notebook execution.
     */
    public final String editorId() {
        return editorId;
    }

    /**
     * <p>
     * The status filter for listing notebook executions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not
     * begun.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STARTING</code> indicates that the execution is starting on the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> indicates that the execution is being processed by the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISHING</code> indicates that execution processing is in the final stages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISHED</code> indicates that the execution has completed without error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> indicates that the execution failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request
     * and the stop is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a
     * <code>StopNotebookExecution</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
     * request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotebookExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status filter for listing notebook executions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>START_PENDING</code> indicates that the cluster has received the execution request but execution
     *         has not begun.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STARTING</code> indicates that the execution is starting on the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> indicates that the execution is being processed by the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISHING</code> indicates that execution processing is in the final stages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISHED</code> indicates that the execution has completed without error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> indicates that the execution failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
     *         request and the stop is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result
     *         of a <code>StopNotebookExecution</code> request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
     *         request.
     *         </p>
     *         </li>
     * @see NotebookExecutionStatus
     */
    public final NotebookExecutionStatus status() {
        return NotebookExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status filter for listing notebook executions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not
     * begun.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STARTING</code> indicates that the execution is starting on the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> indicates that the execution is being processed by the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISHING</code> indicates that execution processing is in the final stages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISHED</code> indicates that the execution has completed without error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> indicates that the execution failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request
     * and the stop is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a
     * <code>StopNotebookExecution</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
     * request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotebookExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status filter for listing notebook executions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>START_PENDING</code> indicates that the cluster has received the execution request but execution
     *         has not begun.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STARTING</code> indicates that the execution is starting on the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> indicates that the execution is being processed by the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISHING</code> indicates that execution processing is in the final stages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISHED</code> indicates that the execution has completed without error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> indicates that the execution failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
     *         request and the stop is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result
     *         of a <code>StopNotebookExecution</code> request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
     *         request.
     *         </p>
     *         </li>
     * @see NotebookExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The beginning of time range filter for listing notebook executions. The default is the timestamp of 30 days ago.
     * </p>
     * 
     * @return The beginning of time range filter for listing notebook executions. The default is the timestamp of 30
     *         days ago.
     */
    public final Instant from() {
        return from;
    }

    /**
     * <p>
     * The end of time range filter for listing notebook executions. The default is the current timestamp.
     * </p>
     * 
     * @return The end of time range filter for listing notebook executions. The default is the current timestamp.
     */
    public final Instant to() {
        return to;
    }

    /**
     * <p>
     * The pagination token, returned by a previous <code>ListNotebookExecutions</code> call, that indicates the start
     * of the list for this <code>ListNotebookExecutions</code> call.
     * </p>
     * 
     * @return The pagination token, returned by a previous <code>ListNotebookExecutions</code> call, that indicates the
     *         start of the list for this <code>ListNotebookExecutions</code> call.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The unique ID of the execution engine.
     * </p>
     * 
     * @return The unique ID of the execution engine.
     */
    public final String executionEngineId() {
        return executionEngineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(editorId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(executionEngineId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookExecutionsRequest)) {
            return false;
        }
        ListNotebookExecutionsRequest other = (ListNotebookExecutionsRequest) obj;
        return Objects.equals(editorId(), other.editorId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(from(), other.from()) && Objects.equals(to(), other.to())
                && Objects.equals(marker(), other.marker()) && Objects.equals(executionEngineId(), other.executionEngineId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotebookExecutionsRequest").add("EditorId", editorId()).add("Status", statusAsString())
                .add("From", from()).add("To", to()).add("Marker", marker()).add("ExecutionEngineId", executionEngineId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EditorId":
            return Optional.ofNullable(clazz.cast(editorId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "To":
            return Optional.ofNullable(clazz.cast(to()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ExecutionEngineId":
            return Optional.ofNullable(clazz.cast(executionEngineId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookExecutionsRequest, T> g) {
        return obj -> g.apply((ListNotebookExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListNotebookExecutionsRequest> {
        /**
         * <p>
         * The unique ID of the editor associated with the notebook execution.
         * </p>
         * 
         * @param editorId
         *        The unique ID of the editor associated with the notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder editorId(String editorId);

        /**
         * <p>
         * The status filter for listing notebook executions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has
         * not begun.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STARTING</code> indicates that the execution is starting on the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> indicates that the execution is being processed by the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISHING</code> indicates that execution processing is in the final stages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISHED</code> indicates that the execution has completed without error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> indicates that the execution failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
         * request and the stop is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a
         * <code>StopNotebookExecution</code> request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
         * request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status filter for listing notebook executions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>START_PENDING</code> indicates that the cluster has received the execution request but execution
         *        has not begun.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STARTING</code> indicates that the execution is starting on the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> indicates that the execution is being processed by the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISHING</code> indicates that execution processing is in the final stages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISHED</code> indicates that the execution has completed without error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> indicates that the execution failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
         *        request and the stop is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a
         *        result of a <code>StopNotebookExecution</code> request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> indicates that the execution stopped because of a
         *        <code>StopNotebookExecution</code> request.
         *        </p>
         *        </li>
         * @see NotebookExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status filter for listing notebook executions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has
         * not begun.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STARTING</code> indicates that the execution is starting on the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> indicates that the execution is being processed by the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISHING</code> indicates that execution processing is in the final stages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISHED</code> indicates that the execution has completed without error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> indicates that the execution failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
         * request and the stop is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a
         * <code>StopNotebookExecution</code> request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
         * request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status filter for listing notebook executions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>START_PENDING</code> indicates that the cluster has received the execution request but execution
         *        has not begun.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STARTING</code> indicates that the execution is starting on the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> indicates that the execution is being processed by the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISHING</code> indicates that execution processing is in the final stages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISHED</code> indicates that the execution has completed without error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> indicates that the execution failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
         *        request and the stop is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a
         *        result of a <code>StopNotebookExecution</code> request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> indicates that the execution stopped because of a
         *        <code>StopNotebookExecution</code> request.
         *        </p>
         *        </li>
         * @see NotebookExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookExecutionStatus
         */
        Builder status(NotebookExecutionStatus status);

        /**
         * <p>
         * The beginning of time range filter for listing notebook executions. The default is the timestamp of 30 days
         * ago.
         * </p>
         * 
         * @param from
         *        The beginning of time range filter for listing notebook executions. The default is the timestamp of 30
         *        days ago.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(Instant from);

        /**
         * <p>
         * The end of time range filter for listing notebook executions. The default is the current timestamp.
         * </p>
         * 
         * @param to
         *        The end of time range filter for listing notebook executions. The default is the current timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Instant to);

        /**
         * <p>
         * The pagination token, returned by a previous <code>ListNotebookExecutions</code> call, that indicates the
         * start of the list for this <code>ListNotebookExecutions</code> call.
         * </p>
         * 
         * @param marker
         *        The pagination token, returned by a previous <code>ListNotebookExecutions</code> call, that indicates
         *        the start of the list for this <code>ListNotebookExecutions</code> call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The unique ID of the execution engine.
         * </p>
         * 
         * @param executionEngineId
         *        The unique ID of the execution engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEngineId(String executionEngineId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String editorId;

        private String status;

        private Instant from;

        private Instant to;

        private String marker;

        private String executionEngineId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookExecutionsRequest model) {
            super(model);
            editorId(model.editorId);
            status(model.status);
            from(model.from);
            to(model.to);
            marker(model.marker);
            executionEngineId(model.executionEngineId);
        }

        public final String getEditorId() {
            return editorId;
        }

        public final void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        @Override
        public final Builder editorId(String editorId) {
            this.editorId = editorId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotebookExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getFrom() {
            return from;
        }

        public final void setFrom(Instant from) {
            this.from = from;
        }

        @Override
        public final Builder from(Instant from) {
            this.from = from;
            return this;
        }

        public final Instant getTo() {
            return to;
        }

        public final void setTo(Instant to) {
            this.to = to;
        }

        @Override
        public final Builder to(Instant to) {
            this.to = to;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getExecutionEngineId() {
            return executionEngineId;
        }

        public final void setExecutionEngineId(String executionEngineId) {
            this.executionEngineId = executionEngineId;
        }

        @Override
        public final Builder executionEngineId(String executionEngineId) {
            this.executionEngineId = executionEngineId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotebookExecutionsRequest build() {
            return new ListNotebookExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
