/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.model.DescribeClusterRequest;
import software.amazon.awssdk.services.emr.model.DescribeClusterResponse;
import software.amazon.awssdk.services.emr.model.DescribeStepRequest;
import software.amazon.awssdk.services.emr.model.DescribeStepResponse;
import software.amazon.awssdk.services.emr.waiters.DefaultEmrAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
public interface EmrAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterRunning(DescribeClusterRequest describeClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterRunning(Consumer<DescribeClusterRequest.Builder> describeClusterRequest) {
        return this.waitUntilClusterRunning((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterRunning(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterRunning(Consumer<DescribeClusterRequest.Builder> describeClusterRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilClusterRunning((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterTerminated(DescribeClusterRequest describeClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterTerminated(Consumer<DescribeClusterRequest.Builder> describeClusterRequest) {
        return this.waitUntilClusterTerminated((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterTerminated(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterTerminated(Consumer<DescribeClusterRequest.Builder> describeClusterRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilClusterTerminated((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeStepResponse>> waitUntilStepComplete(DescribeStepRequest describeStepRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeStepResponse>> waitUntilStepComplete(Consumer<DescribeStepRequest.Builder> describeStepRequest) {
        return this.waitUntilStepComplete((DescribeStepRequest)((Object)((DescribeStepRequest.Builder)DescribeStepRequest.builder().applyMutation(describeStepRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeStepResponse>> waitUntilStepComplete(DescribeStepRequest describeStepRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeStepResponse>> waitUntilStepComplete(Consumer<DescribeStepRequest.Builder> describeStepRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilStepComplete((DescribeStepRequest)((Object)((DescribeStepRequest.Builder)DescribeStepRequest.builder().applyMutation(describeStepRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultEmrAsyncWaiter.builder();
    }

    public static EmrAsyncWaiter create() {
        return DefaultEmrAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(EmrAsyncClient var1);

        public EmrAsyncWaiter build();
    }
}

