/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthMode {
    SSO("SSO"),
    IAM("IAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthMode> VALUE_MAP;
    private final String value;

    private AuthMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthMode> knownValues() {
        EnumSet<AuthMode> knownValues = EnumSet.allOf(AuthMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthMode.class, AuthMode::toString);
    }
}

