/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.SimplifiedApplication;
import software.amazon.awssdk.services.emr.model.SimplifiedApplicationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReleaseLabelResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, DescribeReleaseLabelResponse> {
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseLabel").getter(DescribeReleaseLabelResponse.getter(DescribeReleaseLabelResponse::releaseLabel)).setter(DescribeReleaseLabelResponse.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseLabel").build()}).build();
    private static final SdkField<List<SimplifiedApplication>> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Applications").getter(DescribeReleaseLabelResponse.getter(DescribeReleaseLabelResponse::applications)).setter(DescribeReleaseLabelResponse.setter(Builder::applications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimplifiedApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReleaseLabelResponse.getter(DescribeReleaseLabelResponse::nextToken)).setter(DescribeReleaseLabelResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEASE_LABEL_FIELD, APPLICATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final String releaseLabel;
    private final List<SimplifiedApplication> applications;
    private final String nextToken;

    private DescribeReleaseLabelResponse(BuilderImpl builder) {
        super(builder);
        this.releaseLabel = builder.releaseLabel;
        this.applications = builder.applications;
        this.nextToken = builder.nextToken;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final boolean hasApplications() {
        return this.applications != null && !(this.applications instanceof SdkAutoConstructList);
    }

    public final List<SimplifiedApplication> applications() {
        return this.applications;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplications() ? this.applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReleaseLabelResponse)) {
            return false;
        }
        DescribeReleaseLabelResponse other = (DescribeReleaseLabelResponse)((Object)obj);
        return Objects.equals(this.releaseLabel(), other.releaseLabel()) && this.hasApplications() == other.hasApplications() && Objects.equals(this.applications(), other.applications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReleaseLabelResponse").add("ReleaseLabel", (Object)this.releaseLabel()).add("Applications", this.hasApplications() ? this.applications() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReleaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "Applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReleaseLabelResponse, T> g) {
        return obj -> g.apply((DescribeReleaseLabelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private String releaseLabel;
        private List<SimplifiedApplication> applications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReleaseLabelResponse model) {
            super(model);
            this.releaseLabel(model.releaseLabel);
            this.applications(model.applications);
            this.nextToken(model.nextToken);
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        @Transient
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final List<SimplifiedApplication.Builder> getApplications() {
            List<SimplifiedApplication.Builder> result = SimplifiedApplicationListCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<SimplifiedApplication.BuilderImpl> applications) {
            this.applications = SimplifiedApplicationListCopier.copyFromBuilder(applications);
        }

        @Override
        @Transient
        public final Builder applications(Collection<SimplifiedApplication> applications) {
            this.applications = SimplifiedApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applications(SimplifiedApplication ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applications(Consumer<SimplifiedApplication.Builder> ... applications) {
            this.applications(Stream.of(applications).map(c -> (SimplifiedApplication)((SimplifiedApplication.Builder)SimplifiedApplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeReleaseLabelResponse build() {
            return new DescribeReleaseLabelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReleaseLabelResponse> {
        public Builder releaseLabel(String var1);

        public Builder applications(Collection<SimplifiedApplication> var1);

        public Builder applications(SimplifiedApplication ... var1);

        public Builder applications(Consumer<SimplifiedApplication.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

