/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.Application;
import software.amazon.awssdk.services.emr.model.ApplicationListCopier;
import software.amazon.awssdk.services.emr.model.BootstrapActionConfig;
import software.amazon.awssdk.services.emr.model.BootstrapActionConfigListCopier;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig;
import software.amazon.awssdk.services.emr.model.KerberosAttributes;
import software.amazon.awssdk.services.emr.model.ManagedScalingPolicy;
import software.amazon.awssdk.services.emr.model.NewSupportedProductsListCopier;
import software.amazon.awssdk.services.emr.model.PlacementGroupConfig;
import software.amazon.awssdk.services.emr.model.PlacementGroupConfigListCopier;
import software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot;
import software.amazon.awssdk.services.emr.model.ScaleDownBehavior;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.model.StepConfigListCopier;
import software.amazon.awssdk.services.emr.model.SupportedProductConfig;
import software.amazon.awssdk.services.emr.model.SupportedProductsListCopier;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunJobFlowRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, RunJobFlowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RunJobFlowRequest.getter(RunJobFlowRequest::name)).setter(RunJobFlowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> LOG_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogUri").getter(RunJobFlowRequest.getter(RunJobFlowRequest::logUri)).setter(RunJobFlowRequest.setter(Builder::logUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUri").build()}).build();
    private static final SdkField<String> LOG_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogEncryptionKmsKeyId").getter(RunJobFlowRequest.getter(RunJobFlowRequest::logEncryptionKmsKeyId)).setter(RunJobFlowRequest.setter(Builder::logEncryptionKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogEncryptionKmsKeyId").build()}).build();
    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalInfo").getter(RunJobFlowRequest.getter(RunJobFlowRequest::additionalInfo)).setter(RunJobFlowRequest.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").build()}).build();
    private static final SdkField<String> AMI_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiVersion").getter(RunJobFlowRequest.getter(RunJobFlowRequest::amiVersion)).setter(RunJobFlowRequest.setter(Builder::amiVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiVersion").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseLabel").getter(RunJobFlowRequest.getter(RunJobFlowRequest::releaseLabel)).setter(RunJobFlowRequest.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseLabel").build()}).build();
    private static final SdkField<JobFlowInstancesConfig> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Instances").getter(RunJobFlowRequest.getter(RunJobFlowRequest::instances)).setter(RunJobFlowRequest.setter(Builder::instances)).constructor(JobFlowInstancesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build()}).build();
    private static final SdkField<List<StepConfig>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Steps").getter(RunJobFlowRequest.getter(RunJobFlowRequest::steps)).setter(RunJobFlowRequest.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BootstrapActionConfig>> BOOTSTRAP_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BootstrapActions").getter(RunJobFlowRequest.getter(RunJobFlowRequest::bootstrapActions)).setter(RunJobFlowRequest.setter(Builder::bootstrapActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootstrapActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BootstrapActionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedProducts").getter(RunJobFlowRequest.getter(RunJobFlowRequest::supportedProducts)).setter(RunJobFlowRequest.setter(Builder::supportedProducts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedProducts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SupportedProductConfig>> NEW_SUPPORTED_PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NewSupportedProducts").getter(RunJobFlowRequest.getter(RunJobFlowRequest::newSupportedProducts)).setter(RunJobFlowRequest.setter(Builder::newSupportedProducts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewSupportedProducts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupportedProductConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Application>> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Applications").getter(RunJobFlowRequest.getter(RunJobFlowRequest::applications)).setter(RunJobFlowRequest.setter(Builder::applications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Application::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Configurations").getter(RunJobFlowRequest.getter(RunJobFlowRequest::configurations)).setter(RunJobFlowRequest.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> VISIBLE_TO_ALL_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VisibleToAllUsers").getter(RunJobFlowRequest.getter(RunJobFlowRequest::visibleToAllUsers)).setter(RunJobFlowRequest.setter(Builder::visibleToAllUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibleToAllUsers").build()}).build();
    private static final SdkField<String> JOB_FLOW_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobFlowRole").getter(RunJobFlowRequest.getter(RunJobFlowRequest::jobFlowRole)).setter(RunJobFlowRequest.setter(Builder::jobFlowRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowRole").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(RunJobFlowRequest.getter(RunJobFlowRequest::serviceRole)).setter(RunJobFlowRequest.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RunJobFlowRequest.getter(RunJobFlowRequest::tags)).setter(RunJobFlowRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(RunJobFlowRequest.getter(RunJobFlowRequest::securityConfiguration)).setter(RunJobFlowRequest.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<String> AUTO_SCALING_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingRole").getter(RunJobFlowRequest.getter(RunJobFlowRequest::autoScalingRole)).setter(RunJobFlowRequest.setter(Builder::autoScalingRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingRole").build()}).build();
    private static final SdkField<String> SCALE_DOWN_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScaleDownBehavior").getter(RunJobFlowRequest.getter(RunJobFlowRequest::scaleDownBehaviorAsString)).setter(RunJobFlowRequest.setter(Builder::scaleDownBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleDownBehavior").build()}).build();
    private static final SdkField<String> CUSTOM_AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomAmiId").getter(RunJobFlowRequest.getter(RunJobFlowRequest::customAmiId)).setter(RunJobFlowRequest.setter(Builder::customAmiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAmiId").build()}).build();
    private static final SdkField<Integer> EBS_ROOT_VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EbsRootVolumeSize").getter(RunJobFlowRequest.getter(RunJobFlowRequest::ebsRootVolumeSize)).setter(RunJobFlowRequest.setter(Builder::ebsRootVolumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsRootVolumeSize").build()}).build();
    private static final SdkField<String> REPO_UPGRADE_ON_BOOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepoUpgradeOnBoot").getter(RunJobFlowRequest.getter(RunJobFlowRequest::repoUpgradeOnBootAsString)).setter(RunJobFlowRequest.setter(Builder::repoUpgradeOnBoot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepoUpgradeOnBoot").build()}).build();
    private static final SdkField<KerberosAttributes> KERBEROS_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KerberosAttributes").getter(RunJobFlowRequest.getter(RunJobFlowRequest::kerberosAttributes)).setter(RunJobFlowRequest.setter(Builder::kerberosAttributes)).constructor(KerberosAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosAttributes").build()}).build();
    private static final SdkField<Integer> STEP_CONCURRENCY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StepConcurrencyLevel").getter(RunJobFlowRequest.getter(RunJobFlowRequest::stepConcurrencyLevel)).setter(RunJobFlowRequest.setter(Builder::stepConcurrencyLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepConcurrencyLevel").build()}).build();
    private static final SdkField<ManagedScalingPolicy> MANAGED_SCALING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedScalingPolicy").getter(RunJobFlowRequest.getter(RunJobFlowRequest::managedScalingPolicy)).setter(RunJobFlowRequest.setter(Builder::managedScalingPolicy)).constructor(ManagedScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedScalingPolicy").build()}).build();
    private static final SdkField<List<PlacementGroupConfig>> PLACEMENT_GROUP_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlacementGroupConfigs").getter(RunJobFlowRequest.getter(RunJobFlowRequest::placementGroupConfigs)).setter(RunJobFlowRequest.setter(Builder::placementGroupConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroupConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementGroupConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LOG_URI_FIELD, LOG_ENCRYPTION_KMS_KEY_ID_FIELD, ADDITIONAL_INFO_FIELD, AMI_VERSION_FIELD, RELEASE_LABEL_FIELD, INSTANCES_FIELD, STEPS_FIELD, BOOTSTRAP_ACTIONS_FIELD, SUPPORTED_PRODUCTS_FIELD, NEW_SUPPORTED_PRODUCTS_FIELD, APPLICATIONS_FIELD, CONFIGURATIONS_FIELD, VISIBLE_TO_ALL_USERS_FIELD, JOB_FLOW_ROLE_FIELD, SERVICE_ROLE_FIELD, TAGS_FIELD, SECURITY_CONFIGURATION_FIELD, AUTO_SCALING_ROLE_FIELD, SCALE_DOWN_BEHAVIOR_FIELD, CUSTOM_AMI_ID_FIELD, EBS_ROOT_VOLUME_SIZE_FIELD, REPO_UPGRADE_ON_BOOT_FIELD, KERBEROS_ATTRIBUTES_FIELD, STEP_CONCURRENCY_LEVEL_FIELD, MANAGED_SCALING_POLICY_FIELD, PLACEMENT_GROUP_CONFIGS_FIELD));
    private final String name;
    private final String logUri;
    private final String logEncryptionKmsKeyId;
    private final String additionalInfo;
    private final String amiVersion;
    private final String releaseLabel;
    private final JobFlowInstancesConfig instances;
    private final List<StepConfig> steps;
    private final List<BootstrapActionConfig> bootstrapActions;
    private final List<String> supportedProducts;
    private final List<SupportedProductConfig> newSupportedProducts;
    private final List<Application> applications;
    private final List<Configuration> configurations;
    private final Boolean visibleToAllUsers;
    private final String jobFlowRole;
    private final String serviceRole;
    private final List<Tag> tags;
    private final String securityConfiguration;
    private final String autoScalingRole;
    private final String scaleDownBehavior;
    private final String customAmiId;
    private final Integer ebsRootVolumeSize;
    private final String repoUpgradeOnBoot;
    private final KerberosAttributes kerberosAttributes;
    private final Integer stepConcurrencyLevel;
    private final ManagedScalingPolicy managedScalingPolicy;
    private final List<PlacementGroupConfig> placementGroupConfigs;

    private RunJobFlowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.logUri = builder.logUri;
        this.logEncryptionKmsKeyId = builder.logEncryptionKmsKeyId;
        this.additionalInfo = builder.additionalInfo;
        this.amiVersion = builder.amiVersion;
        this.releaseLabel = builder.releaseLabel;
        this.instances = builder.instances;
        this.steps = builder.steps;
        this.bootstrapActions = builder.bootstrapActions;
        this.supportedProducts = builder.supportedProducts;
        this.newSupportedProducts = builder.newSupportedProducts;
        this.applications = builder.applications;
        this.configurations = builder.configurations;
        this.visibleToAllUsers = builder.visibleToAllUsers;
        this.jobFlowRole = builder.jobFlowRole;
        this.serviceRole = builder.serviceRole;
        this.tags = builder.tags;
        this.securityConfiguration = builder.securityConfiguration;
        this.autoScalingRole = builder.autoScalingRole;
        this.scaleDownBehavior = builder.scaleDownBehavior;
        this.customAmiId = builder.customAmiId;
        this.ebsRootVolumeSize = builder.ebsRootVolumeSize;
        this.repoUpgradeOnBoot = builder.repoUpgradeOnBoot;
        this.kerberosAttributes = builder.kerberosAttributes;
        this.stepConcurrencyLevel = builder.stepConcurrencyLevel;
        this.managedScalingPolicy = builder.managedScalingPolicy;
        this.placementGroupConfigs = builder.placementGroupConfigs;
    }

    public final String name() {
        return this.name;
    }

    public final String logUri() {
        return this.logUri;
    }

    public final String logEncryptionKmsKeyId() {
        return this.logEncryptionKmsKeyId;
    }

    public final String additionalInfo() {
        return this.additionalInfo;
    }

    public final String amiVersion() {
        return this.amiVersion;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final JobFlowInstancesConfig instances() {
        return this.instances;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<StepConfig> steps() {
        return this.steps;
    }

    public final boolean hasBootstrapActions() {
        return this.bootstrapActions != null && !(this.bootstrapActions instanceof SdkAutoConstructList);
    }

    public final List<BootstrapActionConfig> bootstrapActions() {
        return this.bootstrapActions;
    }

    public final boolean hasSupportedProducts() {
        return this.supportedProducts != null && !(this.supportedProducts instanceof SdkAutoConstructList);
    }

    public final List<String> supportedProducts() {
        return this.supportedProducts;
    }

    public final boolean hasNewSupportedProducts() {
        return this.newSupportedProducts != null && !(this.newSupportedProducts instanceof SdkAutoConstructList);
    }

    public final List<SupportedProductConfig> newSupportedProducts() {
        return this.newSupportedProducts;
    }

    public final boolean hasApplications() {
        return this.applications != null && !(this.applications instanceof SdkAutoConstructList);
    }

    public final List<Application> applications() {
        return this.applications;
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructList);
    }

    public final List<Configuration> configurations() {
        return this.configurations;
    }

    public final Boolean visibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public final String jobFlowRole() {
        return this.jobFlowRole;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    public final String autoScalingRole() {
        return this.autoScalingRole;
    }

    public final ScaleDownBehavior scaleDownBehavior() {
        return ScaleDownBehavior.fromValue(this.scaleDownBehavior);
    }

    public final String scaleDownBehaviorAsString() {
        return this.scaleDownBehavior;
    }

    public final String customAmiId() {
        return this.customAmiId;
    }

    public final Integer ebsRootVolumeSize() {
        return this.ebsRootVolumeSize;
    }

    public final RepoUpgradeOnBoot repoUpgradeOnBoot() {
        return RepoUpgradeOnBoot.fromValue(this.repoUpgradeOnBoot);
    }

    public final String repoUpgradeOnBootAsString() {
        return this.repoUpgradeOnBoot;
    }

    public final KerberosAttributes kerberosAttributes() {
        return this.kerberosAttributes;
    }

    public final Integer stepConcurrencyLevel() {
        return this.stepConcurrencyLevel;
    }

    public final ManagedScalingPolicy managedScalingPolicy() {
        return this.managedScalingPolicy;
    }

    public final boolean hasPlacementGroupConfigs() {
        return this.placementGroupConfigs != null && !(this.placementGroupConfigs instanceof SdkAutoConstructList);
    }

    public final List<PlacementGroupConfig> placementGroupConfigs() {
        return this.placementGroupConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.logEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBootstrapActions() ? this.bootstrapActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedProducts() ? this.supportedProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewSupportedProducts() ? this.newSupportedProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplications() ? this.applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visibleToAllUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleDownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsRootVolumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.repoUpgradeOnBootAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kerberosAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepConcurrencyLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedScalingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementGroupConfigs() ? this.placementGroupConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunJobFlowRequest)) {
            return false;
        }
        RunJobFlowRequest other = (RunJobFlowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.logEncryptionKmsKeyId(), other.logEncryptionKmsKeyId()) && Objects.equals(this.additionalInfo(), other.additionalInfo()) && Objects.equals(this.amiVersion(), other.amiVersion()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.instances(), other.instances()) && this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && this.hasBootstrapActions() == other.hasBootstrapActions() && Objects.equals(this.bootstrapActions(), other.bootstrapActions()) && this.hasSupportedProducts() == other.hasSupportedProducts() && Objects.equals(this.supportedProducts(), other.supportedProducts()) && this.hasNewSupportedProducts() == other.hasNewSupportedProducts() && Objects.equals(this.newSupportedProducts(), other.newSupportedProducts()) && this.hasApplications() == other.hasApplications() && Objects.equals(this.applications(), other.applications()) && this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.visibleToAllUsers(), other.visibleToAllUsers()) && Objects.equals(this.jobFlowRole(), other.jobFlowRole()) && Objects.equals(this.serviceRole(), other.serviceRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.autoScalingRole(), other.autoScalingRole()) && Objects.equals(this.scaleDownBehaviorAsString(), other.scaleDownBehaviorAsString()) && Objects.equals(this.customAmiId(), other.customAmiId()) && Objects.equals(this.ebsRootVolumeSize(), other.ebsRootVolumeSize()) && Objects.equals(this.repoUpgradeOnBootAsString(), other.repoUpgradeOnBootAsString()) && Objects.equals(this.kerberosAttributes(), other.kerberosAttributes()) && Objects.equals(this.stepConcurrencyLevel(), other.stepConcurrencyLevel()) && Objects.equals(this.managedScalingPolicy(), other.managedScalingPolicy()) && this.hasPlacementGroupConfigs() == other.hasPlacementGroupConfigs() && Objects.equals(this.placementGroupConfigs(), other.placementGroupConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"RunJobFlowRequest").add("Name", (Object)this.name()).add("LogUri", (Object)this.logUri()).add("LogEncryptionKmsKeyId", (Object)this.logEncryptionKmsKeyId()).add("AdditionalInfo", (Object)this.additionalInfo()).add("AmiVersion", (Object)this.amiVersion()).add("ReleaseLabel", (Object)this.releaseLabel()).add("Instances", (Object)this.instances()).add("Steps", this.hasSteps() ? this.steps() : null).add("BootstrapActions", this.hasBootstrapActions() ? this.bootstrapActions() : null).add("SupportedProducts", this.hasSupportedProducts() ? this.supportedProducts() : null).add("NewSupportedProducts", this.hasNewSupportedProducts() ? this.newSupportedProducts() : null).add("Applications", this.hasApplications() ? this.applications() : null).add("Configurations", this.hasConfigurations() ? this.configurations() : null).add("VisibleToAllUsers", (Object)this.visibleToAllUsers()).add("JobFlowRole", (Object)this.jobFlowRole()).add("ServiceRole", (Object)this.serviceRole()).add("Tags", this.hasTags() ? this.tags() : null).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("AutoScalingRole", (Object)this.autoScalingRole()).add("ScaleDownBehavior", (Object)this.scaleDownBehaviorAsString()).add("CustomAmiId", (Object)this.customAmiId()).add("EbsRootVolumeSize", (Object)this.ebsRootVolumeSize()).add("RepoUpgradeOnBoot", (Object)this.repoUpgradeOnBootAsString()).add("KerberosAttributes", (Object)this.kerberosAttributes()).add("StepConcurrencyLevel", (Object)this.stepConcurrencyLevel()).add("ManagedScalingPolicy", (Object)this.managedScalingPolicy()).add("PlacementGroupConfigs", this.hasPlacementGroupConfigs() ? this.placementGroupConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "LogUri": {
                return Optional.ofNullable(clazz.cast(this.logUri()));
            }
            case "LogEncryptionKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.logEncryptionKmsKeyId()));
            }
            case "AdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "AmiVersion": {
                return Optional.ofNullable(clazz.cast(this.amiVersion()));
            }
            case "ReleaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "Steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "BootstrapActions": {
                return Optional.ofNullable(clazz.cast(this.bootstrapActions()));
            }
            case "SupportedProducts": {
                return Optional.ofNullable(clazz.cast(this.supportedProducts()));
            }
            case "NewSupportedProducts": {
                return Optional.ofNullable(clazz.cast(this.newSupportedProducts()));
            }
            case "Applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "VisibleToAllUsers": {
                return Optional.ofNullable(clazz.cast(this.visibleToAllUsers()));
            }
            case "JobFlowRole": {
                return Optional.ofNullable(clazz.cast(this.jobFlowRole()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "AutoScalingRole": {
                return Optional.ofNullable(clazz.cast(this.autoScalingRole()));
            }
            case "ScaleDownBehavior": {
                return Optional.ofNullable(clazz.cast(this.scaleDownBehaviorAsString()));
            }
            case "CustomAmiId": {
                return Optional.ofNullable(clazz.cast(this.customAmiId()));
            }
            case "EbsRootVolumeSize": {
                return Optional.ofNullable(clazz.cast(this.ebsRootVolumeSize()));
            }
            case "RepoUpgradeOnBoot": {
                return Optional.ofNullable(clazz.cast(this.repoUpgradeOnBootAsString()));
            }
            case "KerberosAttributes": {
                return Optional.ofNullable(clazz.cast(this.kerberosAttributes()));
            }
            case "StepConcurrencyLevel": {
                return Optional.ofNullable(clazz.cast(this.stepConcurrencyLevel()));
            }
            case "ManagedScalingPolicy": {
                return Optional.ofNullable(clazz.cast(this.managedScalingPolicy()));
            }
            case "PlacementGroupConfigs": {
                return Optional.ofNullable(clazz.cast(this.placementGroupConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunJobFlowRequest, T> g) {
        return obj -> g.apply((RunJobFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String name;
        private String logUri;
        private String logEncryptionKmsKeyId;
        private String additionalInfo;
        private String amiVersion;
        private String releaseLabel;
        private JobFlowInstancesConfig instances;
        private List<StepConfig> steps = DefaultSdkAutoConstructList.getInstance();
        private List<BootstrapActionConfig> bootstrapActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedProducts = DefaultSdkAutoConstructList.getInstance();
        private List<SupportedProductConfig> newSupportedProducts = DefaultSdkAutoConstructList.getInstance();
        private List<Application> applications = DefaultSdkAutoConstructList.getInstance();
        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();
        private Boolean visibleToAllUsers;
        private String jobFlowRole;
        private String serviceRole;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String securityConfiguration;
        private String autoScalingRole;
        private String scaleDownBehavior;
        private String customAmiId;
        private Integer ebsRootVolumeSize;
        private String repoUpgradeOnBoot;
        private KerberosAttributes kerberosAttributes;
        private Integer stepConcurrencyLevel;
        private ManagedScalingPolicy managedScalingPolicy;
        private List<PlacementGroupConfig> placementGroupConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RunJobFlowRequest model) {
            super(model);
            this.name(model.name);
            this.logUri(model.logUri);
            this.logEncryptionKmsKeyId(model.logEncryptionKmsKeyId);
            this.additionalInfo(model.additionalInfo);
            this.amiVersion(model.amiVersion);
            this.releaseLabel(model.releaseLabel);
            this.instances(model.instances);
            this.steps(model.steps);
            this.bootstrapActions(model.bootstrapActions);
            this.supportedProducts(model.supportedProducts);
            this.newSupportedProducts(model.newSupportedProducts);
            this.applications(model.applications);
            this.configurations(model.configurations);
            this.visibleToAllUsers(model.visibleToAllUsers);
            this.jobFlowRole(model.jobFlowRole);
            this.serviceRole(model.serviceRole);
            this.tags(model.tags);
            this.securityConfiguration(model.securityConfiguration);
            this.autoScalingRole(model.autoScalingRole);
            this.scaleDownBehavior(model.scaleDownBehavior);
            this.customAmiId(model.customAmiId);
            this.ebsRootVolumeSize(model.ebsRootVolumeSize);
            this.repoUpgradeOnBoot(model.repoUpgradeOnBoot);
            this.kerberosAttributes(model.kerberosAttributes);
            this.stepConcurrencyLevel(model.stepConcurrencyLevel);
            this.managedScalingPolicy(model.managedScalingPolicy);
            this.placementGroupConfigs(model.placementGroupConfigs);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getLogEncryptionKmsKeyId() {
            return this.logEncryptionKmsKeyId;
        }

        @Override
        public final Builder logEncryptionKmsKeyId(String logEncryptionKmsKeyId) {
            this.logEncryptionKmsKeyId = logEncryptionKmsKeyId;
            return this;
        }

        public final void setLogEncryptionKmsKeyId(String logEncryptionKmsKeyId) {
            this.logEncryptionKmsKeyId = logEncryptionKmsKeyId;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getAmiVersion() {
            return this.amiVersion;
        }

        @Override
        public final Builder amiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
            return this;
        }

        public final void setAmiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        public final JobFlowInstancesConfig.Builder getInstances() {
            return this.instances != null ? this.instances.toBuilder() : null;
        }

        @Override
        public final Builder instances(JobFlowInstancesConfig instances) {
            this.instances = instances;
            return this;
        }

        public final void setInstances(JobFlowInstancesConfig.BuilderImpl instances) {
            this.instances = instances != null ? instances.build() : null;
        }

        public final Collection<StepConfig.Builder> getSteps() {
            if (this.steps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.steps != null ? (Collection)this.steps.stream().map(StepConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder steps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepConfig ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<StepConfig.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (StepConfig)((StepConfig.Builder)StepConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSteps(Collection<StepConfig.BuilderImpl> steps) {
            this.steps = StepConfigListCopier.copyFromBuilder(steps);
        }

        public final Collection<BootstrapActionConfig.Builder> getBootstrapActions() {
            if (this.bootstrapActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bootstrapActions != null ? (Collection)this.bootstrapActions.stream().map(BootstrapActionConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
            this.bootstrapActions = BootstrapActionConfigListCopier.copy(bootstrapActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(BootstrapActionConfig ... bootstrapActions) {
            this.bootstrapActions(Arrays.asList(bootstrapActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(Consumer<BootstrapActionConfig.Builder> ... bootstrapActions) {
            this.bootstrapActions(Stream.of(bootstrapActions).map(c -> (BootstrapActionConfig)((BootstrapActionConfig.Builder)BootstrapActionConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBootstrapActions(Collection<BootstrapActionConfig.BuilderImpl> bootstrapActions) {
            this.bootstrapActions = BootstrapActionConfigListCopier.copyFromBuilder(bootstrapActions);
        }

        public final Collection<String> getSupportedProducts() {
            if (this.supportedProducts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedProducts;
        }

        @Override
        public final Builder supportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedProducts(String ... supportedProducts) {
            this.supportedProducts(Arrays.asList(supportedProducts));
            return this;
        }

        public final void setSupportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
        }

        public final Collection<SupportedProductConfig.Builder> getNewSupportedProducts() {
            if (this.newSupportedProducts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.newSupportedProducts != null ? (Collection)this.newSupportedProducts.stream().map(SupportedProductConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder newSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts) {
            this.newSupportedProducts = NewSupportedProductsListCopier.copy(newSupportedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newSupportedProducts(SupportedProductConfig ... newSupportedProducts) {
            this.newSupportedProducts(Arrays.asList(newSupportedProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newSupportedProducts(Consumer<SupportedProductConfig.Builder> ... newSupportedProducts) {
            this.newSupportedProducts(Stream.of(newSupportedProducts).map(c -> (SupportedProductConfig)((SupportedProductConfig.Builder)SupportedProductConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNewSupportedProducts(Collection<SupportedProductConfig.BuilderImpl> newSupportedProducts) {
            this.newSupportedProducts = NewSupportedProductsListCopier.copyFromBuilder(newSupportedProducts);
        }

        public final Collection<Application.Builder> getApplications() {
            if (this.applications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applications != null ? (Collection)this.applications.stream().map(Application::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<Application.Builder> ... applications) {
            this.applications(Stream.of(applications).map(c -> (Application)((Application.Builder)Application.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationListCopier.copyFromBuilder(applications);
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            if (this.configurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        public final Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        public final void setVisibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
        }

        public final String getJobFlowRole() {
            return this.jobFlowRole;
        }

        @Override
        public final Builder jobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
            return this;
        }

        public final void setJobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final String getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public final Builder autoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        public final void setAutoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
        }

        public final String getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public final Builder scaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        @Override
        public final Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior(scaleDownBehavior == null ? null : scaleDownBehavior.toString());
            return this;
        }

        public final void setScaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
        }

        public final String getCustomAmiId() {
            return this.customAmiId;
        }

        @Override
        public final Builder customAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        public final void setCustomAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
        }

        public final Integer getEbsRootVolumeSize() {
            return this.ebsRootVolumeSize;
        }

        @Override
        public final Builder ebsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        public final void setEbsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
        }

        public final String getRepoUpgradeOnBoot() {
            return this.repoUpgradeOnBoot;
        }

        @Override
        public final Builder repoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
            return this;
        }

        @Override
        public final Builder repoUpgradeOnBoot(RepoUpgradeOnBoot repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot(repoUpgradeOnBoot == null ? null : repoUpgradeOnBoot.toString());
            return this;
        }

        public final void setRepoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
        }

        public final KerberosAttributes.Builder getKerberosAttributes() {
            return this.kerberosAttributes != null ? this.kerberosAttributes.toBuilder() : null;
        }

        @Override
        public final Builder kerberosAttributes(KerberosAttributes kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes;
            return this;
        }

        public final void setKerberosAttributes(KerberosAttributes.BuilderImpl kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes != null ? kerberosAttributes.build() : null;
        }

        public final Integer getStepConcurrencyLevel() {
            return this.stepConcurrencyLevel;
        }

        @Override
        public final Builder stepConcurrencyLevel(Integer stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
            return this;
        }

        public final void setStepConcurrencyLevel(Integer stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
        }

        public final ManagedScalingPolicy.Builder getManagedScalingPolicy() {
            return this.managedScalingPolicy != null ? this.managedScalingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder managedScalingPolicy(ManagedScalingPolicy managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy;
            return this;
        }

        public final void setManagedScalingPolicy(ManagedScalingPolicy.BuilderImpl managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy != null ? managedScalingPolicy.build() : null;
        }

        public final Collection<PlacementGroupConfig.Builder> getPlacementGroupConfigs() {
            if (this.placementGroupConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.placementGroupConfigs != null ? (Collection)this.placementGroupConfigs.stream().map(PlacementGroupConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementGroupConfigs(Collection<PlacementGroupConfig> placementGroupConfigs) {
            this.placementGroupConfigs = PlacementGroupConfigListCopier.copy(placementGroupConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroupConfigs(PlacementGroupConfig ... placementGroupConfigs) {
            this.placementGroupConfigs(Arrays.asList(placementGroupConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroupConfigs(Consumer<PlacementGroupConfig.Builder> ... placementGroupConfigs) {
            this.placementGroupConfigs(Stream.of(placementGroupConfigs).map(c -> (PlacementGroupConfig)((PlacementGroupConfig.Builder)PlacementGroupConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementGroupConfigs(Collection<PlacementGroupConfig.BuilderImpl> placementGroupConfigs) {
            this.placementGroupConfigs = PlacementGroupConfigListCopier.copyFromBuilder(placementGroupConfigs);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunJobFlowRequest build() {
            return new RunJobFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunJobFlowRequest> {
        public Builder name(String var1);

        public Builder logUri(String var1);

        public Builder logEncryptionKmsKeyId(String var1);

        public Builder additionalInfo(String var1);

        public Builder amiVersion(String var1);

        public Builder releaseLabel(String var1);

        public Builder instances(JobFlowInstancesConfig var1);

        default public Builder instances(Consumer<JobFlowInstancesConfig.Builder> instances) {
            return this.instances((JobFlowInstancesConfig)((JobFlowInstancesConfig.Builder)JobFlowInstancesConfig.builder().applyMutation(instances)).build());
        }

        public Builder steps(Collection<StepConfig> var1);

        public Builder steps(StepConfig ... var1);

        public Builder steps(Consumer<StepConfig.Builder> ... var1);

        public Builder bootstrapActions(Collection<BootstrapActionConfig> var1);

        public Builder bootstrapActions(BootstrapActionConfig ... var1);

        public Builder bootstrapActions(Consumer<BootstrapActionConfig.Builder> ... var1);

        public Builder supportedProducts(Collection<String> var1);

        public Builder supportedProducts(String ... var1);

        public Builder newSupportedProducts(Collection<SupportedProductConfig> var1);

        public Builder newSupportedProducts(SupportedProductConfig ... var1);

        public Builder newSupportedProducts(Consumer<SupportedProductConfig.Builder> ... var1);

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder applications(Consumer<Application.Builder> ... var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder configurations(Consumer<Configuration.Builder> ... var1);

        public Builder visibleToAllUsers(Boolean var1);

        public Builder jobFlowRole(String var1);

        public Builder serviceRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder securityConfiguration(String var1);

        public Builder autoScalingRole(String var1);

        public Builder scaleDownBehavior(String var1);

        public Builder scaleDownBehavior(ScaleDownBehavior var1);

        public Builder customAmiId(String var1);

        public Builder ebsRootVolumeSize(Integer var1);

        public Builder repoUpgradeOnBoot(String var1);

        public Builder repoUpgradeOnBoot(RepoUpgradeOnBoot var1);

        public Builder kerberosAttributes(KerberosAttributes var1);

        default public Builder kerberosAttributes(Consumer<KerberosAttributes.Builder> kerberosAttributes) {
            return this.kerberosAttributes((KerberosAttributes)((KerberosAttributes.Builder)KerberosAttributes.builder().applyMutation(kerberosAttributes)).build());
        }

        public Builder stepConcurrencyLevel(Integer var1);

        public Builder managedScalingPolicy(ManagedScalingPolicy var1);

        default public Builder managedScalingPolicy(Consumer<ManagedScalingPolicy.Builder> managedScalingPolicy) {
            return this.managedScalingPolicy((ManagedScalingPolicy)((ManagedScalingPolicy.Builder)ManagedScalingPolicy.builder().applyMutation(managedScalingPolicy)).build());
        }

        public Builder placementGroupConfigs(Collection<PlacementGroupConfig> var1);

        public Builder placementGroupConfigs(PlacementGroupConfig ... var1);

        public Builder placementGroupConfigs(Consumer<PlacementGroupConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

