/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringMaxLen256ListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2InstanceAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2InstanceAttributes> {
    private static final SdkField<String> EC2_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2KeyName").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::ec2KeyName)).setter(Ec2InstanceAttributes.setter(Builder::ec2KeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2KeyName").build()}).build();
    private static final SdkField<String> EC2_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2SubnetId").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::ec2SubnetId)).setter(Ec2InstanceAttributes.setter(Builder::ec2SubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2SubnetId").build()}).build();
    private static final SdkField<List<String>> REQUESTED_EC2_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedEc2SubnetIds").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::requestedEc2SubnetIds)).setter(Ec2InstanceAttributes.setter(Builder::requestedEc2SubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedEc2SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EC2_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2AvailabilityZone").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::ec2AvailabilityZone)).setter(Ec2InstanceAttributes.setter(Builder::ec2AvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2AvailabilityZone").build()}).build();
    private static final SdkField<List<String>> REQUESTED_EC2_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedEc2AvailabilityZones").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::requestedEc2AvailabilityZones)).setter(Ec2InstanceAttributes.setter(Builder::requestedEc2AvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedEc2AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamInstanceProfile").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::iamInstanceProfile)).setter(Ec2InstanceAttributes.setter(Builder::iamInstanceProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build()}).build();
    private static final SdkField<String> EMR_MANAGED_MASTER_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmrManagedMasterSecurityGroup").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::emrManagedMasterSecurityGroup)).setter(Ec2InstanceAttributes.setter(Builder::emrManagedMasterSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmrManagedMasterSecurityGroup").build()}).build();
    private static final SdkField<String> EMR_MANAGED_SLAVE_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmrManagedSlaveSecurityGroup").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::emrManagedSlaveSecurityGroup)).setter(Ec2InstanceAttributes.setter(Builder::emrManagedSlaveSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmrManagedSlaveSecurityGroup").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessSecurityGroup").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::serviceAccessSecurityGroup)).setter(Ec2InstanceAttributes.setter(Builder::serviceAccessSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessSecurityGroup").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_MASTER_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalMasterSecurityGroups").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::additionalMasterSecurityGroups)).setter(Ec2InstanceAttributes.setter(Builder::additionalMasterSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMasterSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_SLAVE_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalSlaveSecurityGroups").getter(Ec2InstanceAttributes.getter(Ec2InstanceAttributes::additionalSlaveSecurityGroups)).setter(Ec2InstanceAttributes.setter(Builder::additionalSlaveSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalSlaveSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_KEY_NAME_FIELD, EC2_SUBNET_ID_FIELD, REQUESTED_EC2_SUBNET_IDS_FIELD, EC2_AVAILABILITY_ZONE_FIELD, REQUESTED_EC2_AVAILABILITY_ZONES_FIELD, IAM_INSTANCE_PROFILE_FIELD, EMR_MANAGED_MASTER_SECURITY_GROUP_FIELD, EMR_MANAGED_SLAVE_SECURITY_GROUP_FIELD, SERVICE_ACCESS_SECURITY_GROUP_FIELD, ADDITIONAL_MASTER_SECURITY_GROUPS_FIELD, ADDITIONAL_SLAVE_SECURITY_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ec2KeyName;
    private final String ec2SubnetId;
    private final List<String> requestedEc2SubnetIds;
    private final String ec2AvailabilityZone;
    private final List<String> requestedEc2AvailabilityZones;
    private final String iamInstanceProfile;
    private final String emrManagedMasterSecurityGroup;
    private final String emrManagedSlaveSecurityGroup;
    private final String serviceAccessSecurityGroup;
    private final List<String> additionalMasterSecurityGroups;
    private final List<String> additionalSlaveSecurityGroups;

    private Ec2InstanceAttributes(BuilderImpl builder) {
        this.ec2KeyName = builder.ec2KeyName;
        this.ec2SubnetId = builder.ec2SubnetId;
        this.requestedEc2SubnetIds = builder.requestedEc2SubnetIds;
        this.ec2AvailabilityZone = builder.ec2AvailabilityZone;
        this.requestedEc2AvailabilityZones = builder.requestedEc2AvailabilityZones;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.emrManagedMasterSecurityGroup = builder.emrManagedMasterSecurityGroup;
        this.emrManagedSlaveSecurityGroup = builder.emrManagedSlaveSecurityGroup;
        this.serviceAccessSecurityGroup = builder.serviceAccessSecurityGroup;
        this.additionalMasterSecurityGroups = builder.additionalMasterSecurityGroups;
        this.additionalSlaveSecurityGroups = builder.additionalSlaveSecurityGroups;
    }

    public String ec2KeyName() {
        return this.ec2KeyName;
    }

    public String ec2SubnetId() {
        return this.ec2SubnetId;
    }

    public boolean hasRequestedEc2SubnetIds() {
        return this.requestedEc2SubnetIds != null && !(this.requestedEc2SubnetIds instanceof SdkAutoConstructList);
    }

    public List<String> requestedEc2SubnetIds() {
        return this.requestedEc2SubnetIds;
    }

    public String ec2AvailabilityZone() {
        return this.ec2AvailabilityZone;
    }

    public boolean hasRequestedEc2AvailabilityZones() {
        return this.requestedEc2AvailabilityZones != null && !(this.requestedEc2AvailabilityZones instanceof SdkAutoConstructList);
    }

    public List<String> requestedEc2AvailabilityZones() {
        return this.requestedEc2AvailabilityZones;
    }

    public String iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String emrManagedMasterSecurityGroup() {
        return this.emrManagedMasterSecurityGroup;
    }

    public String emrManagedSlaveSecurityGroup() {
        return this.emrManagedSlaveSecurityGroup;
    }

    public String serviceAccessSecurityGroup() {
        return this.serviceAccessSecurityGroup;
    }

    public boolean hasAdditionalMasterSecurityGroups() {
        return this.additionalMasterSecurityGroups != null && !(this.additionalMasterSecurityGroups instanceof SdkAutoConstructList);
    }

    public List<String> additionalMasterSecurityGroups() {
        return this.additionalMasterSecurityGroups;
    }

    public boolean hasAdditionalSlaveSecurityGroups() {
        return this.additionalSlaveSecurityGroups != null && !(this.additionalSlaveSecurityGroups instanceof SdkAutoConstructList);
    }

    public List<String> additionalSlaveSecurityGroups() {
        return this.additionalSlaveSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2KeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedEc2SubnetIds() ? this.requestedEc2SubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2AvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedEc2AvailabilityZones() ? this.requestedEc2AvailabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.emrManagedMasterSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.emrManagedSlaveSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalMasterSecurityGroups() ? this.additionalMasterSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalSlaveSecurityGroups() ? this.additionalSlaveSecurityGroups() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2InstanceAttributes)) {
            return false;
        }
        Ec2InstanceAttributes other = (Ec2InstanceAttributes)obj;
        return Objects.equals(this.ec2KeyName(), other.ec2KeyName()) && Objects.equals(this.ec2SubnetId(), other.ec2SubnetId()) && this.hasRequestedEc2SubnetIds() == other.hasRequestedEc2SubnetIds() && Objects.equals(this.requestedEc2SubnetIds(), other.requestedEc2SubnetIds()) && Objects.equals(this.ec2AvailabilityZone(), other.ec2AvailabilityZone()) && this.hasRequestedEc2AvailabilityZones() == other.hasRequestedEc2AvailabilityZones() && Objects.equals(this.requestedEc2AvailabilityZones(), other.requestedEc2AvailabilityZones()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.emrManagedMasterSecurityGroup(), other.emrManagedMasterSecurityGroup()) && Objects.equals(this.emrManagedSlaveSecurityGroup(), other.emrManagedSlaveSecurityGroup()) && Objects.equals(this.serviceAccessSecurityGroup(), other.serviceAccessSecurityGroup()) && this.hasAdditionalMasterSecurityGroups() == other.hasAdditionalMasterSecurityGroups() && Objects.equals(this.additionalMasterSecurityGroups(), other.additionalMasterSecurityGroups()) && this.hasAdditionalSlaveSecurityGroups() == other.hasAdditionalSlaveSecurityGroups() && Objects.equals(this.additionalSlaveSecurityGroups(), other.additionalSlaveSecurityGroups());
    }

    public String toString() {
        return ToString.builder((String)"Ec2InstanceAttributes").add("Ec2KeyName", (Object)this.ec2KeyName()).add("Ec2SubnetId", (Object)this.ec2SubnetId()).add("RequestedEc2SubnetIds", this.hasRequestedEc2SubnetIds() ? this.requestedEc2SubnetIds() : null).add("Ec2AvailabilityZone", (Object)this.ec2AvailabilityZone()).add("RequestedEc2AvailabilityZones", this.hasRequestedEc2AvailabilityZones() ? this.requestedEc2AvailabilityZones() : null).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("EmrManagedMasterSecurityGroup", (Object)this.emrManagedMasterSecurityGroup()).add("EmrManagedSlaveSecurityGroup", (Object)this.emrManagedSlaveSecurityGroup()).add("ServiceAccessSecurityGroup", (Object)this.serviceAccessSecurityGroup()).add("AdditionalMasterSecurityGroups", this.hasAdditionalMasterSecurityGroups() ? this.additionalMasterSecurityGroups() : null).add("AdditionalSlaveSecurityGroups", this.hasAdditionalSlaveSecurityGroups() ? this.additionalSlaveSecurityGroups() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ec2KeyName": {
                return Optional.ofNullable(clazz.cast(this.ec2KeyName()));
            }
            case "Ec2SubnetId": {
                return Optional.ofNullable(clazz.cast(this.ec2SubnetId()));
            }
            case "RequestedEc2SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.requestedEc2SubnetIds()));
            }
            case "Ec2AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.ec2AvailabilityZone()));
            }
            case "RequestedEc2AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.requestedEc2AvailabilityZones()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "EmrManagedMasterSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.emrManagedMasterSecurityGroup()));
            }
            case "EmrManagedSlaveSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.emrManagedSlaveSecurityGroup()));
            }
            case "ServiceAccessSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessSecurityGroup()));
            }
            case "AdditionalMasterSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.additionalMasterSecurityGroups()));
            }
            case "AdditionalSlaveSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.additionalSlaveSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2InstanceAttributes, T> g) {
        return obj -> g.apply((Ec2InstanceAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2KeyName;
        private String ec2SubnetId;
        private List<String> requestedEc2SubnetIds = DefaultSdkAutoConstructList.getInstance();
        private String ec2AvailabilityZone;
        private List<String> requestedEc2AvailabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String iamInstanceProfile;
        private String emrManagedMasterSecurityGroup;
        private String emrManagedSlaveSecurityGroup;
        private String serviceAccessSecurityGroup;
        private List<String> additionalMasterSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> additionalSlaveSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2InstanceAttributes model) {
            this.ec2KeyName(model.ec2KeyName);
            this.ec2SubnetId(model.ec2SubnetId);
            this.requestedEc2SubnetIds(model.requestedEc2SubnetIds);
            this.ec2AvailabilityZone(model.ec2AvailabilityZone);
            this.requestedEc2AvailabilityZones(model.requestedEc2AvailabilityZones);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.emrManagedMasterSecurityGroup(model.emrManagedMasterSecurityGroup);
            this.emrManagedSlaveSecurityGroup(model.emrManagedSlaveSecurityGroup);
            this.serviceAccessSecurityGroup(model.serviceAccessSecurityGroup);
            this.additionalMasterSecurityGroups(model.additionalMasterSecurityGroups);
            this.additionalSlaveSecurityGroups(model.additionalSlaveSecurityGroups);
        }

        public final String getEc2KeyName() {
            return this.ec2KeyName;
        }

        @Override
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        public final String getEc2SubnetId() {
            return this.ec2SubnetId;
        }

        @Override
        public final Builder ec2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
            return this;
        }

        public final void setEc2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
        }

        public final Collection<String> getRequestedEc2SubnetIds() {
            if (this.requestedEc2SubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requestedEc2SubnetIds;
        }

        @Override
        public final Builder requestedEc2SubnetIds(Collection<String> requestedEc2SubnetIds) {
            this.requestedEc2SubnetIds = XmlStringMaxLen256ListCopier.copy(requestedEc2SubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedEc2SubnetIds(String ... requestedEc2SubnetIds) {
            this.requestedEc2SubnetIds(Arrays.asList(requestedEc2SubnetIds));
            return this;
        }

        public final void setRequestedEc2SubnetIds(Collection<String> requestedEc2SubnetIds) {
            this.requestedEc2SubnetIds = XmlStringMaxLen256ListCopier.copy(requestedEc2SubnetIds);
        }

        public final String getEc2AvailabilityZone() {
            return this.ec2AvailabilityZone;
        }

        @Override
        public final Builder ec2AvailabilityZone(String ec2AvailabilityZone) {
            this.ec2AvailabilityZone = ec2AvailabilityZone;
            return this;
        }

        public final void setEc2AvailabilityZone(String ec2AvailabilityZone) {
            this.ec2AvailabilityZone = ec2AvailabilityZone;
        }

        public final Collection<String> getRequestedEc2AvailabilityZones() {
            if (this.requestedEc2AvailabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requestedEc2AvailabilityZones;
        }

        @Override
        public final Builder requestedEc2AvailabilityZones(Collection<String> requestedEc2AvailabilityZones) {
            this.requestedEc2AvailabilityZones = XmlStringMaxLen256ListCopier.copy(requestedEc2AvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedEc2AvailabilityZones(String ... requestedEc2AvailabilityZones) {
            this.requestedEc2AvailabilityZones(Arrays.asList(requestedEc2AvailabilityZones));
            return this;
        }

        public final void setRequestedEc2AvailabilityZones(Collection<String> requestedEc2AvailabilityZones) {
            this.requestedEc2AvailabilityZones = XmlStringMaxLen256ListCopier.copy(requestedEc2AvailabilityZones);
        }

        public final String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final String getEmrManagedMasterSecurityGroup() {
            return this.emrManagedMasterSecurityGroup;
        }

        @Override
        public final Builder emrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
            return this;
        }

        public final void setEmrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
        }

        public final String getEmrManagedSlaveSecurityGroup() {
            return this.emrManagedSlaveSecurityGroup;
        }

        @Override
        public final Builder emrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
            return this;
        }

        public final void setEmrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
        }

        public final String getServiceAccessSecurityGroup() {
            return this.serviceAccessSecurityGroup;
        }

        @Override
        public final Builder serviceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
            return this;
        }

        public final void setServiceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
        }

        public final Collection<String> getAdditionalMasterSecurityGroups() {
            if (this.additionalMasterSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalMasterSecurityGroups;
        }

        @Override
        public final Builder additionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = StringListCopier.copy(additionalMasterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMasterSecurityGroups(String ... additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups(Arrays.asList(additionalMasterSecurityGroups));
            return this;
        }

        public final void setAdditionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = StringListCopier.copy(additionalMasterSecurityGroups);
        }

        public final Collection<String> getAdditionalSlaveSecurityGroups() {
            if (this.additionalSlaveSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalSlaveSecurityGroups;
        }

        @Override
        public final Builder additionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = StringListCopier.copy(additionalSlaveSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSlaveSecurityGroups(String ... additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups(Arrays.asList(additionalSlaveSecurityGroups));
            return this;
        }

        public final void setAdditionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = StringListCopier.copy(additionalSlaveSecurityGroups);
        }

        public Ec2InstanceAttributes build() {
            return new Ec2InstanceAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2InstanceAttributes> {
        public Builder ec2KeyName(String var1);

        public Builder ec2SubnetId(String var1);

        public Builder requestedEc2SubnetIds(Collection<String> var1);

        public Builder requestedEc2SubnetIds(String ... var1);

        public Builder ec2AvailabilityZone(String var1);

        public Builder requestedEc2AvailabilityZones(Collection<String> var1);

        public Builder requestedEc2AvailabilityZones(String ... var1);

        public Builder iamInstanceProfile(String var1);

        public Builder emrManagedMasterSecurityGroup(String var1);

        public Builder emrManagedSlaveSecurityGroup(String var1);

        public Builder serviceAccessSecurityGroup(String var1);

        public Builder additionalMasterSecurityGroups(Collection<String> var1);

        public Builder additionalMasterSecurityGroups(String ... var1);

        public Builder additionalSlaveSecurityGroups(Collection<String> var1);

        public Builder additionalSlaveSecurityGroups(String ... var1);
    }
}

