/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.ClusterState;
import software.amazon.awssdk.services.emr.model.ClusterStateListCopier;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClustersRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, ListClustersRequest> {
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAfter").getter(ListClustersRequest.getter(ListClustersRequest::createdAfter)).setter(ListClustersRequest.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedBefore").getter(ListClustersRequest.getter(ListClustersRequest::createdBefore)).setter(ListClustersRequest.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()}).build();
    private static final SdkField<List<String>> CLUSTER_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterStates").getter(ListClustersRequest.getter(ListClustersRequest::clusterStatesAsStrings)).setter(ListClustersRequest.setter(Builder::clusterStatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListClustersRequest.getter(ListClustersRequest::marker)).setter(ListClustersRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, CLUSTER_STATES_FIELD, MARKER_FIELD));
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final List<String> clusterStates;
    private final String marker;

    private ListClustersRequest(BuilderImpl builder) {
        super(builder);
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.clusterStates = builder.clusterStates;
        this.marker = builder.marker;
    }

    public Instant createdAfter() {
        return this.createdAfter;
    }

    public Instant createdBefore() {
        return this.createdBefore;
    }

    public List<ClusterState> clusterStates() {
        return ClusterStateListCopier.copyStringToEnum(this.clusterStates);
    }

    public boolean hasClusterStates() {
        return this.clusterStates != null && !(this.clusterStates instanceof SdkAutoConstructList);
    }

    public List<String> clusterStatesAsStrings() {
        return this.clusterStates;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterStates() ? this.clusterStatesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest)((Object)obj);
        return Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && this.hasClusterStates() == other.hasClusterStates() && Objects.equals(this.clusterStatesAsStrings(), other.clusterStatesAsStrings()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListClustersRequest").add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("ClusterStates", this.hasClusterStates() ? this.clusterStatesAsStrings() : null).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "ClusterStates": {
                return Optional.ofNullable(clazz.cast(this.clusterStatesAsStrings()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersRequest, T> g) {
        return obj -> g.apply((ListClustersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private Instant createdAfter;
        private Instant createdBefore;
        private List<String> clusterStates = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersRequest model) {
            super(model);
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.clusterStatesWithStrings(model.clusterStates);
            this.marker(model.marker);
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Collection<String> getClusterStates() {
            if (this.clusterStates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusterStates;
        }

        @Override
        public final Builder clusterStatesWithStrings(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterStatesWithStrings(String ... clusterStates) {
            this.clusterStatesWithStrings(Arrays.asList(clusterStates));
            return this;
        }

        @Override
        public final Builder clusterStates(Collection<ClusterState> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copyEnumToString(clusterStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterStates(ClusterState ... clusterStates) {
            this.clusterStates(Arrays.asList(clusterStates));
            return this;
        }

        public final void setClusterStates(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClustersRequest build() {
            return new ListClustersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClustersRequest> {
        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder clusterStatesWithStrings(Collection<String> var1);

        public Builder clusterStatesWithStrings(String ... var1);

        public Builder clusterStates(Collection<ClusterState> var1);

        public Builder clusterStates(ClusterState ... var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

