/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnDemandProvisioningSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnDemandProvisioningSpecification> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationStrategy").getter(OnDemandProvisioningSpecification.getter(OnDemandProvisioningSpecification::allocationStrategyAsString)).setter(OnDemandProvisioningSpecification.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allocationStrategy;

    private OnDemandProvisioningSpecification(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
    }

    public OnDemandProvisioningAllocationStrategy allocationStrategy() {
        return OnDemandProvisioningAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandProvisioningSpecification)) {
            return false;
        }
        OnDemandProvisioningSpecification other = (OnDemandProvisioningSpecification)obj;
        return Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"OnDemandProvisioningSpecification").add("AllocationStrategy", (Object)this.allocationStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandProvisioningSpecification, T> g) {
        return obj -> g.apply((OnDemandProvisioningSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandProvisioningSpecification model) {
            this.allocationStrategy(model.allocationStrategy);
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(OnDemandProvisioningAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public OnDemandProvisioningSpecification build() {
            return new OnDemandProvisioningSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnDemandProvisioningSpecification> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(OnDemandProvisioningAllocationStrategy var1);
    }
}

