/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.InstanceState;
import software.amazon.awssdk.services.emr.model.InstanceStateChangeReason;
import software.amazon.awssdk.services.emr.model.InstanceTimeline;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceStatus.getter(InstanceStatus::stateAsString)).setter(InstanceStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<InstanceStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceStatus.getter(InstanceStatus::stateChangeReason)).setter(InstanceStatus.setter(Builder::stateChangeReason)).constructor(InstanceStateChangeReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final SdkField<InstanceTimeline> TIMELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceStatus.getter(InstanceStatus::timeline)).setter(InstanceStatus.setter(Builder::timeline)).constructor(InstanceTimeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STATE_CHANGE_REASON_FIELD, TIMELINE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final InstanceStateChangeReason stateChangeReason;
    private final InstanceTimeline timeline;

    private InstanceStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    public InstanceState state() {
        return InstanceState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public InstanceStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public InstanceTimeline timeline() {
        return this.timeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.timeline(), other.timeline());
    }

    public String toString() {
        return ToString.builder((String)"InstanceStatus").add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("Timeline", (Object)this.timeline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "Timeline": {
                return Optional.ofNullable(clazz.cast(this.timeline()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStatus, T> g) {
        return obj -> g.apply((InstanceStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private InstanceStateChangeReason stateChangeReason;
        private InstanceTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.timeline(model.timeline);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final InstanceStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(InstanceStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(InstanceStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final InstanceTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        @Override
        public final Builder timeline(InstanceTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(InstanceTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        public InstanceStatus build() {
            return new InstanceStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceStatus> {
        public Builder state(String var1);

        public Builder state(InstanceState var1);

        public Builder stateChangeReason(InstanceStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<InstanceStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((InstanceStateChangeReason)((InstanceStateChangeReason.Builder)InstanceStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }

        public Builder timeline(InstanceTimeline var1);

        default public Builder timeline(Consumer<InstanceTimeline.Builder> timeline) {
            return this.timeline((InstanceTimeline)((InstanceTimeline.Builder)InstanceTimeline.builder().applyMutation(timeline)).build());
        }
    }
}

