/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceGroupType {
    MASTER("MASTER"),
    CORE("CORE"),
    TASK("TASK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceGroupType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceGroupType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceGroupType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceGroupType> knownValues() {
        return Stream.of(InstanceGroupType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

