/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Command
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Command> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Command.getter(Command::name)).setter(Command.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCRIPT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Command.getter(Command::scriptPath)).setter(Command.setter(Builder::scriptPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptPath").build()}).build();
    private static final SdkField<List<String>> ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Command.getter(Command::args)).setter(Command.setter(Builder::args)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCRIPT_PATH_FIELD, ARGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String scriptPath;
    private final List<String> args;

    private Command(BuilderImpl builder) {
        this.name = builder.name;
        this.scriptPath = builder.scriptPath;
        this.args = builder.args;
    }

    public String name() {
        return this.name;
    }

    public String scriptPath() {
        return this.scriptPath;
    }

    public boolean hasArgs() {
        return this.args != null && !(this.args instanceof SdkAutoConstructList);
    }

    public List<String> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.args());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scriptPath(), other.scriptPath()) && Objects.equals(this.args(), other.args());
    }

    public String toString() {
        return ToString.builder((String)"Command").add("Name", (Object)this.name()).add("ScriptPath", (Object)this.scriptPath()).add("Args", this.args()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ScriptPath": {
                return Optional.ofNullable(clazz.cast(this.scriptPath()));
            }
            case "Args": {
                return Optional.ofNullable(clazz.cast(this.args()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Command, T> g) {
        return obj -> g.apply((Command)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String scriptPath;
        private List<String> args = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            this.name(model.name);
            this.scriptPath(model.scriptPath);
            this.args(model.args);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getScriptPath() {
            return this.scriptPath;
        }

        @Override
        public final Builder scriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
            return this;
        }

        public final void setScriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        public final Collection<String> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = StringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = StringListCopier.copy(args);
        }

        public Command build() {
            return new Command(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Command> {
        public Builder name(String var1);

        public Builder scriptPath(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);
    }
}

