/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig;
import software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceGroupsRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, ModifyInstanceGroupsRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyInstanceGroupsRequest.getter(ModifyInstanceGroupsRequest::clusterId)).setter(ModifyInstanceGroupsRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<List<InstanceGroupModifyConfig>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyInstanceGroupsRequest.getter(ModifyInstanceGroupsRequest::instanceGroups)).setter(ModifyInstanceGroupsRequest.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceGroupModifyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, INSTANCE_GROUPS_FIELD));
    private final String clusterId;
    private final List<InstanceGroupModifyConfig> instanceGroups;

    private ModifyInstanceGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroups = builder.instanceGroups;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public boolean hasInstanceGroups() {
        return this.instanceGroups != null && !(this.instanceGroups instanceof SdkAutoConstructList);
    }

    public List<InstanceGroupModifyConfig> instanceGroups() {
        return this.instanceGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceGroupsRequest)) {
            return false;
        }
        ModifyInstanceGroupsRequest other = (ModifyInstanceGroupsRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceGroups(), other.instanceGroups());
    }

    public String toString() {
        return ToString.builder((String)"ModifyInstanceGroupsRequest").add("ClusterId", (Object)this.clusterId()).add("InstanceGroups", this.instanceGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceGroupsRequest, T> g) {
        return obj -> g.apply((ModifyInstanceGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private List<InstanceGroupModifyConfig> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceGroupsRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.instanceGroups(model.instanceGroups);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<InstanceGroupModifyConfig.Builder> getInstanceGroups() {
            return this.instanceGroups != null ? (Collection)this.instanceGroups.stream().map(InstanceGroupModifyConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupModifyConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupModifyConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<InstanceGroupModifyConfig.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (InstanceGroupModifyConfig)((InstanceGroupModifyConfig.Builder)InstanceGroupModifyConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupModifyConfig.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupModifyConfigListCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceGroupsRequest build() {
            return new ModifyInstanceGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceGroupsRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroups(Collection<InstanceGroupModifyConfig> var1);

        public Builder instanceGroups(InstanceGroupModifyConfig ... var1);

        public Builder instanceGroups(Consumer<InstanceGroupModifyConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

