/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;
import software.amazon.awssdk.services.emr.model.ListStepsResponse;
import software.amazon.awssdk.services.emr.model.StepSummary;

public class ListStepsPublisher
implements SdkPublisher<ListStepsResponse> {
    private final EmrAsyncClient client;
    private final ListStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStepsPublisher(EmrAsyncClient client, ListStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStepsPublisher(EmrAsyncClient client, ListStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StepSummary> steps() {
        Function<ListStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStepsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListStepsPublisher resume(ListStepsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStepsPublisher(this.client, (ListStepsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListStepsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListStepsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListStepsResponseFetcher
    implements AsyncPageFetcher<ListStepsResponse> {
        private ListStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListStepsResponse> nextPage(ListStepsResponse previousPage) {
            if (previousPage == null) {
                return ListStepsPublisher.this.client.listSteps(ListStepsPublisher.this.firstRequest);
            }
            return ListStepsPublisher.this.client.listSteps((ListStepsRequest)((Object)ListStepsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

