/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyState;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingPolicyStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingPolicyStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingPolicyStatus.getter(AutoScalingPolicyStatus::stateAsString)).setter(AutoScalingPolicyStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<AutoScalingPolicyStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AutoScalingPolicyStatus.getter(AutoScalingPolicyStatus::stateChangeReason)).setter(AutoScalingPolicyStatus.setter(Builder::stateChangeReason)).constructor(AutoScalingPolicyStateChangeReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STATE_CHANGE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final AutoScalingPolicyStateChangeReason stateChangeReason;

    private AutoScalingPolicyStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
    }

    public AutoScalingPolicyState state() {
        return AutoScalingPolicyState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public AutoScalingPolicyStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyStatus)) {
            return false;
        }
        AutoScalingPolicyStatus other = (AutoScalingPolicyStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingPolicyStatus").add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingPolicyStatus, T> g) {
        return obj -> g.apply((AutoScalingPolicyStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private AutoScalingPolicyStateChangeReason stateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AutoScalingPolicyState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final AutoScalingPolicyStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(AutoScalingPolicyStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(AutoScalingPolicyStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public AutoScalingPolicyStatus build() {
            return new AutoScalingPolicyStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingPolicyStatus> {
        public Builder state(String var1);

        public Builder state(AutoScalingPolicyState var1);

        public Builder stateChangeReason(AutoScalingPolicyStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<AutoScalingPolicyStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((AutoScalingPolicyStateChangeReason)((AutoScalingPolicyStateChangeReason.Builder)AutoScalingPolicyStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }
    }
}

