/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.HadoopStepConfig;

public class HadoopStepConfigUnmarshaller
implements Unmarshaller<HadoopStepConfig, JsonUnmarshallerContext> {
    private static final HadoopStepConfigUnmarshaller INSTANCE = new HadoopStepConfigUnmarshaller();

    public HadoopStepConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        HadoopStepConfig.Builder hadoopStepConfigBuilder = HadoopStepConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Jar", targetDepth)) {
                    context.nextToken();
                    hadoopStepConfigBuilder.jar((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Properties", targetDepth)) {
                    context.nextToken();
                    hadoopStepConfigBuilder.properties(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("MainClass", targetDepth)) {
                    context.nextToken();
                    hadoopStepConfigBuilder.mainClass((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Args", targetDepth)) {
                    context.nextToken();
                    hadoopStepConfigBuilder.args(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HadoopStepConfig)hadoopStepConfigBuilder.build();
    }

    public static HadoopStepConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

