/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ActionOnFailure;
import software.amazon.awssdk.services.emr.model.HadoopStepConfig;
import software.amazon.awssdk.services.emr.model.StepStatus;
import software.amazon.awssdk.services.emr.transform.StepSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, StepSummary> {
    private final String id;
    private final String name;
    private final HadoopStepConfig config;
    private final String actionOnFailure;
    private final StepStatus status;

    private StepSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.config = builder.config;
        this.actionOnFailure = builder.actionOnFailure;
        this.status = builder.status;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public HadoopStepConfig config() {
        return this.config;
    }

    public ActionOnFailure actionOnFailure() {
        return ActionOnFailure.fromValue(this.actionOnFailure);
    }

    public String actionOnFailureString() {
        return this.actionOnFailure;
    }

    public StepStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.config());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionOnFailureString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepSummary)) {
            return false;
        }
        StepSummary other = (StepSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.config(), other.config()) && Objects.equals(this.actionOnFailureString(), other.actionOnFailureString()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.config() != null) {
            sb.append("Config: ").append(this.config()).append(",");
        }
        if (this.actionOnFailureString() != null) {
            sb.append("ActionOnFailure: ").append(this.actionOnFailureString()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Config": {
                return Optional.of(clazz.cast(this.config()));
            }
            case "ActionOnFailure": {
                return Optional.of(clazz.cast(this.actionOnFailureString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private HadoopStepConfig config;
        private String actionOnFailure;
        private StepStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(StepSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.config(model.config);
            this.actionOnFailure(model.actionOnFailure);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final HadoopStepConfig.Builder getConfig() {
            return this.config != null ? this.config.toBuilder() : null;
        }

        @Override
        public final Builder config(HadoopStepConfig config) {
            this.config = config;
            return this;
        }

        public final void setConfig(HadoopStepConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        public final String getActionOnFailure() {
            return this.actionOnFailure;
        }

        @Override
        public final Builder actionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        @Override
        public final Builder actionOnFailure(ActionOnFailure actionOnFailure) {
            this.actionOnFailure(actionOnFailure.toString());
            return this;
        }

        public final void setActionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
        }

        public final StepStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(StepStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public StepSummary build() {
            return new StepSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder config(HadoopStepConfig var1);

        default public Builder config(Consumer<HadoopStepConfig.Builder> config) {
            return this.config((HadoopStepConfig)((HadoopStepConfig.Builder)HadoopStepConfig.builder().apply(config)).build());
        }

        public Builder actionOnFailure(String var1);

        public Builder actionOnFailure(ActionOnFailure var1);

        public Builder status(StepStatus var1);

        default public Builder status(Consumer<StepStatus.Builder> status) {
            return this.status((StepStatus)((StepStatus.Builder)StepStatus.builder().apply(status)).build());
        }
    }
}

