/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.emr.model.Application;
import software.amazon.awssdk.services.emr.model.ApplicationListCopier;
import software.amazon.awssdk.services.emr.model.BootstrapActionConfig;
import software.amazon.awssdk.services.emr.model.BootstrapActionConfigListCopier;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig;
import software.amazon.awssdk.services.emr.model.NewSupportedProductsListCopier;
import software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot;
import software.amazon.awssdk.services.emr.model.ScaleDownBehavior;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.model.StepConfigListCopier;
import software.amazon.awssdk.services.emr.model.SupportedProductConfig;
import software.amazon.awssdk.services.emr.model.SupportedProductsListCopier;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RunJobFlowRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, RunJobFlowRequest> {
    private final String name;
    private final String logUri;
    private final String additionalInfo;
    private final String amiVersion;
    private final String releaseLabel;
    private final JobFlowInstancesConfig instances;
    private final List<StepConfig> steps;
    private final List<BootstrapActionConfig> bootstrapActions;
    private final List<String> supportedProducts;
    private final List<SupportedProductConfig> newSupportedProducts;
    private final List<Application> applications;
    private final List<Configuration> configurations;
    private final Boolean visibleToAllUsers;
    private final String jobFlowRole;
    private final String serviceRole;
    private final List<Tag> tags;
    private final String securityConfiguration;
    private final String autoScalingRole;
    private final String scaleDownBehavior;
    private final String customAmiId;
    private final Integer ebsRootVolumeSize;
    private final String repoUpgradeOnBoot;

    private RunJobFlowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.logUri = builder.logUri;
        this.additionalInfo = builder.additionalInfo;
        this.amiVersion = builder.amiVersion;
        this.releaseLabel = builder.releaseLabel;
        this.instances = builder.instances;
        this.steps = builder.steps;
        this.bootstrapActions = builder.bootstrapActions;
        this.supportedProducts = builder.supportedProducts;
        this.newSupportedProducts = builder.newSupportedProducts;
        this.applications = builder.applications;
        this.configurations = builder.configurations;
        this.visibleToAllUsers = builder.visibleToAllUsers;
        this.jobFlowRole = builder.jobFlowRole;
        this.serviceRole = builder.serviceRole;
        this.tags = builder.tags;
        this.securityConfiguration = builder.securityConfiguration;
        this.autoScalingRole = builder.autoScalingRole;
        this.scaleDownBehavior = builder.scaleDownBehavior;
        this.customAmiId = builder.customAmiId;
        this.ebsRootVolumeSize = builder.ebsRootVolumeSize;
        this.repoUpgradeOnBoot = builder.repoUpgradeOnBoot;
    }

    public String name() {
        return this.name;
    }

    public String logUri() {
        return this.logUri;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public String amiVersion() {
        return this.amiVersion;
    }

    public String releaseLabel() {
        return this.releaseLabel;
    }

    public JobFlowInstancesConfig instances() {
        return this.instances;
    }

    public List<StepConfig> steps() {
        return this.steps;
    }

    public List<BootstrapActionConfig> bootstrapActions() {
        return this.bootstrapActions;
    }

    public List<String> supportedProducts() {
        return this.supportedProducts;
    }

    public List<SupportedProductConfig> newSupportedProducts() {
        return this.newSupportedProducts;
    }

    public List<Application> applications() {
        return this.applications;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public Boolean visibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public String jobFlowRole() {
        return this.jobFlowRole;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    public String autoScalingRole() {
        return this.autoScalingRole;
    }

    public ScaleDownBehavior scaleDownBehavior() {
        return ScaleDownBehavior.fromValue(this.scaleDownBehavior);
    }

    public String scaleDownBehaviorString() {
        return this.scaleDownBehavior;
    }

    public String customAmiId() {
        return this.customAmiId;
    }

    public Integer ebsRootVolumeSize() {
        return this.ebsRootVolumeSize;
    }

    public RepoUpgradeOnBoot repoUpgradeOnBoot() {
        return RepoUpgradeOnBoot.fromValue(this.repoUpgradeOnBoot);
    }

    public String repoUpgradeOnBootString() {
        return this.repoUpgradeOnBoot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.steps());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootstrapActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedProducts());
        hashCode = 31 * hashCode + Objects.hashCode(this.newSupportedProducts());
        hashCode = 31 * hashCode + Objects.hashCode(this.applications());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibleToAllUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleDownBehaviorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsRootVolumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.repoUpgradeOnBootString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunJobFlowRequest)) {
            return false;
        }
        RunJobFlowRequest other = (RunJobFlowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.additionalInfo(), other.additionalInfo()) && Objects.equals(this.amiVersion(), other.amiVersion()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.steps(), other.steps()) && Objects.equals(this.bootstrapActions(), other.bootstrapActions()) && Objects.equals(this.supportedProducts(), other.supportedProducts()) && Objects.equals(this.newSupportedProducts(), other.newSupportedProducts()) && Objects.equals(this.applications(), other.applications()) && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.visibleToAllUsers(), other.visibleToAllUsers()) && Objects.equals(this.jobFlowRole(), other.jobFlowRole()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.autoScalingRole(), other.autoScalingRole()) && Objects.equals(this.scaleDownBehaviorString(), other.scaleDownBehaviorString()) && Objects.equals(this.customAmiId(), other.customAmiId()) && Objects.equals(this.ebsRootVolumeSize(), other.ebsRootVolumeSize()) && Objects.equals(this.repoUpgradeOnBootString(), other.repoUpgradeOnBootString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.logUri() != null) {
            sb.append("LogUri: ").append(this.logUri()).append(",");
        }
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        if (this.amiVersion() != null) {
            sb.append("AmiVersion: ").append(this.amiVersion()).append(",");
        }
        if (this.releaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.releaseLabel()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.steps() != null) {
            sb.append("Steps: ").append(this.steps()).append(",");
        }
        if (this.bootstrapActions() != null) {
            sb.append("BootstrapActions: ").append(this.bootstrapActions()).append(",");
        }
        if (this.supportedProducts() != null) {
            sb.append("SupportedProducts: ").append(this.supportedProducts()).append(",");
        }
        if (this.newSupportedProducts() != null) {
            sb.append("NewSupportedProducts: ").append(this.newSupportedProducts()).append(",");
        }
        if (this.applications() != null) {
            sb.append("Applications: ").append(this.applications()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (this.visibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: ").append(this.visibleToAllUsers()).append(",");
        }
        if (this.jobFlowRole() != null) {
            sb.append("JobFlowRole: ").append(this.jobFlowRole()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.securityConfiguration() != null) {
            sb.append("SecurityConfiguration: ").append(this.securityConfiguration()).append(",");
        }
        if (this.autoScalingRole() != null) {
            sb.append("AutoScalingRole: ").append(this.autoScalingRole()).append(",");
        }
        if (this.scaleDownBehaviorString() != null) {
            sb.append("ScaleDownBehavior: ").append(this.scaleDownBehaviorString()).append(",");
        }
        if (this.customAmiId() != null) {
            sb.append("CustomAmiId: ").append(this.customAmiId()).append(",");
        }
        if (this.ebsRootVolumeSize() != null) {
            sb.append("EbsRootVolumeSize: ").append(this.ebsRootVolumeSize()).append(",");
        }
        if (this.repoUpgradeOnBootString() != null) {
            sb.append("RepoUpgradeOnBoot: ").append(this.repoUpgradeOnBootString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "LogUri": {
                return Optional.of(clazz.cast(this.logUri()));
            }
            case "AdditionalInfo": {
                return Optional.of(clazz.cast(this.additionalInfo()));
            }
            case "AmiVersion": {
                return Optional.of(clazz.cast(this.amiVersion()));
            }
            case "ReleaseLabel": {
                return Optional.of(clazz.cast(this.releaseLabel()));
            }
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
            case "Steps": {
                return Optional.of(clazz.cast(this.steps()));
            }
            case "BootstrapActions": {
                return Optional.of(clazz.cast(this.bootstrapActions()));
            }
            case "SupportedProducts": {
                return Optional.of(clazz.cast(this.supportedProducts()));
            }
            case "NewSupportedProducts": {
                return Optional.of(clazz.cast(this.newSupportedProducts()));
            }
            case "Applications": {
                return Optional.of(clazz.cast(this.applications()));
            }
            case "Configurations": {
                return Optional.of(clazz.cast(this.configurations()));
            }
            case "VisibleToAllUsers": {
                return Optional.of(clazz.cast(this.visibleToAllUsers()));
            }
            case "JobFlowRole": {
                return Optional.of(clazz.cast(this.jobFlowRole()));
            }
            case "ServiceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "SecurityConfiguration": {
                return Optional.of(clazz.cast(this.securityConfiguration()));
            }
            case "AutoScalingRole": {
                return Optional.of(clazz.cast(this.autoScalingRole()));
            }
            case "ScaleDownBehavior": {
                return Optional.of(clazz.cast(this.scaleDownBehaviorString()));
            }
            case "CustomAmiId": {
                return Optional.of(clazz.cast(this.customAmiId()));
            }
            case "EbsRootVolumeSize": {
                return Optional.of(clazz.cast(this.ebsRootVolumeSize()));
            }
            case "RepoUpgradeOnBoot": {
                return Optional.of(clazz.cast(this.repoUpgradeOnBootString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private String name;
        private String logUri;
        private String additionalInfo;
        private String amiVersion;
        private String releaseLabel;
        private JobFlowInstancesConfig instances;
        private List<StepConfig> steps;
        private List<BootstrapActionConfig> bootstrapActions;
        private List<String> supportedProducts;
        private List<SupportedProductConfig> newSupportedProducts;
        private List<Application> applications;
        private List<Configuration> configurations;
        private Boolean visibleToAllUsers;
        private String jobFlowRole;
        private String serviceRole;
        private List<Tag> tags;
        private String securityConfiguration;
        private String autoScalingRole;
        private String scaleDownBehavior;
        private String customAmiId;
        private Integer ebsRootVolumeSize;
        private String repoUpgradeOnBoot;

        private BuilderImpl() {
        }

        private BuilderImpl(RunJobFlowRequest model) {
            this.name(model.name);
            this.logUri(model.logUri);
            this.additionalInfo(model.additionalInfo);
            this.amiVersion(model.amiVersion);
            this.releaseLabel(model.releaseLabel);
            this.instances(model.instances);
            this.steps(model.steps);
            this.bootstrapActions(model.bootstrapActions);
            this.supportedProducts(model.supportedProducts);
            this.newSupportedProducts(model.newSupportedProducts);
            this.applications(model.applications);
            this.configurations(model.configurations);
            this.visibleToAllUsers(model.visibleToAllUsers);
            this.jobFlowRole(model.jobFlowRole);
            this.serviceRole(model.serviceRole);
            this.tags(model.tags);
            this.securityConfiguration(model.securityConfiguration);
            this.autoScalingRole(model.autoScalingRole);
            this.scaleDownBehavior(model.scaleDownBehavior);
            this.customAmiId(model.customAmiId);
            this.ebsRootVolumeSize(model.ebsRootVolumeSize);
            this.repoUpgradeOnBoot(model.repoUpgradeOnBoot);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getAmiVersion() {
            return this.amiVersion;
        }

        @Override
        public final Builder amiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
            return this;
        }

        public final void setAmiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        public final JobFlowInstancesConfig.Builder getInstances() {
            return this.instances != null ? this.instances.toBuilder() : null;
        }

        @Override
        public final Builder instances(JobFlowInstancesConfig instances) {
            this.instances = instances;
            return this;
        }

        public final void setInstances(JobFlowInstancesConfig.BuilderImpl instances) {
            this.instances = instances != null ? instances.build() : null;
        }

        public final Collection<StepConfig.Builder> getSteps() {
            return this.steps != null ? (Collection)this.steps.stream().map(StepConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder steps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepConfig ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        public final void setSteps(Collection<StepConfig.BuilderImpl> steps) {
            this.steps = StepConfigListCopier.copyFromBuilder(steps);
        }

        public final Collection<BootstrapActionConfig.Builder> getBootstrapActions() {
            return this.bootstrapActions != null ? (Collection)this.bootstrapActions.stream().map(BootstrapActionConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
            this.bootstrapActions = BootstrapActionConfigListCopier.copy(bootstrapActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(BootstrapActionConfig ... bootstrapActions) {
            this.bootstrapActions(Arrays.asList(bootstrapActions));
            return this;
        }

        public final void setBootstrapActions(Collection<BootstrapActionConfig.BuilderImpl> bootstrapActions) {
            this.bootstrapActions = BootstrapActionConfigListCopier.copyFromBuilder(bootstrapActions);
        }

        public final Collection<String> getSupportedProducts() {
            return this.supportedProducts;
        }

        @Override
        public final Builder supportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedProducts(String ... supportedProducts) {
            this.supportedProducts(Arrays.asList(supportedProducts));
            return this;
        }

        public final void setSupportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
        }

        public final Collection<SupportedProductConfig.Builder> getNewSupportedProducts() {
            return this.newSupportedProducts != null ? (Collection)this.newSupportedProducts.stream().map(SupportedProductConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder newSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts) {
            this.newSupportedProducts = NewSupportedProductsListCopier.copy(newSupportedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newSupportedProducts(SupportedProductConfig ... newSupportedProducts) {
            this.newSupportedProducts(Arrays.asList(newSupportedProducts));
            return this;
        }

        public final void setNewSupportedProducts(Collection<SupportedProductConfig.BuilderImpl> newSupportedProducts) {
            this.newSupportedProducts = NewSupportedProductsListCopier.copyFromBuilder(newSupportedProducts);
        }

        public final Collection<Application.Builder> getApplications() {
            return this.applications != null ? (Collection)this.applications.stream().map(Application::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationListCopier.copyFromBuilder(applications);
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        public final Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        public final void setVisibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
        }

        public final String getJobFlowRole() {
            return this.jobFlowRole;
        }

        @Override
        public final Builder jobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
            return this;
        }

        public final void setJobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final String getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public final Builder autoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        public final void setAutoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
        }

        public final String getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public final Builder scaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        @Override
        public final Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior(scaleDownBehavior.toString());
            return this;
        }

        public final void setScaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
        }

        public final String getCustomAmiId() {
            return this.customAmiId;
        }

        @Override
        public final Builder customAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        public final void setCustomAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
        }

        public final Integer getEbsRootVolumeSize() {
            return this.ebsRootVolumeSize;
        }

        @Override
        public final Builder ebsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        public final void setEbsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
        }

        public final String getRepoUpgradeOnBoot() {
            return this.repoUpgradeOnBoot;
        }

        @Override
        public final Builder repoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
            return this;
        }

        @Override
        public final Builder repoUpgradeOnBoot(RepoUpgradeOnBoot repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot(repoUpgradeOnBoot.toString());
            return this;
        }

        public final void setRepoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RunJobFlowRequest build() {
            return new RunJobFlowRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, RunJobFlowRequest> {
        public Builder name(String var1);

        public Builder logUri(String var1);

        public Builder additionalInfo(String var1);

        public Builder amiVersion(String var1);

        public Builder releaseLabel(String var1);

        public Builder instances(JobFlowInstancesConfig var1);

        default public Builder instances(Consumer<JobFlowInstancesConfig.Builder> instances) {
            return this.instances((JobFlowInstancesConfig)((JobFlowInstancesConfig.Builder)JobFlowInstancesConfig.builder().apply(instances)).build());
        }

        public Builder steps(Collection<StepConfig> var1);

        public Builder steps(StepConfig ... var1);

        public Builder bootstrapActions(Collection<BootstrapActionConfig> var1);

        public Builder bootstrapActions(BootstrapActionConfig ... var1);

        public Builder supportedProducts(Collection<String> var1);

        public Builder supportedProducts(String ... var1);

        public Builder newSupportedProducts(Collection<SupportedProductConfig> var1);

        public Builder newSupportedProducts(SupportedProductConfig ... var1);

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder visibleToAllUsers(Boolean var1);

        public Builder jobFlowRole(String var1);

        public Builder serviceRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder securityConfiguration(String var1);

        public Builder autoScalingRole(String var1);

        public Builder scaleDownBehavior(String var1);

        public Builder scaleDownBehavior(ScaleDownBehavior var1);

        public Builder customAmiId(String var1);

        public Builder ebsRootVolumeSize(Integer var1);

        public Builder repoUpgradeOnBoot(String var1);

        public Builder repoUpgradeOnBoot(RepoUpgradeOnBoot var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

