/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceGroupType;
import software.amazon.awssdk.services.emr.model.InstanceGroupTypeListCopier;
import software.amazon.awssdk.services.emr.model.InstanceState;
import software.amazon.awssdk.services.emr.model.InstanceStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInstancesRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, ListInstancesRequest> {
    private final String clusterId;
    private final String instanceGroupId;
    private final List<String> instanceGroupTypes;
    private final String instanceFleetId;
    private final String instanceFleetType;
    private final List<String> instanceStates;
    private final String marker;

    private ListInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceGroupTypes = builder.instanceGroupTypes;
        this.instanceFleetId = builder.instanceFleetId;
        this.instanceFleetType = builder.instanceFleetType;
        this.instanceStates = builder.instanceStates;
        this.marker = builder.marker;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String instanceGroupId() {
        return this.instanceGroupId;
    }

    public List<InstanceGroupType> instanceGroupTypes() {
        return TypeConverter.convert(this.instanceGroupTypes, InstanceGroupType::fromValue);
    }

    public List<String> instanceGroupTypesStrings() {
        return this.instanceGroupTypes;
    }

    public String instanceFleetId() {
        return this.instanceFleetId;
    }

    public InstanceFleetType instanceFleetType() {
        return InstanceFleetType.fromValue(this.instanceFleetType);
    }

    public String instanceFleetTypeString() {
        return this.instanceFleetType;
    }

    public List<InstanceState> instanceStates() {
        return TypeConverter.convert(this.instanceStates, InstanceState::fromValue);
    }

    public List<String> instanceStatesStrings() {
        return this.instanceStates;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupTypesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.instanceGroupTypesStrings(), other.instanceGroupTypesStrings()) && Objects.equals(this.instanceFleetId(), other.instanceFleetId()) && Objects.equals(this.instanceFleetTypeString(), other.instanceFleetTypeString()) && Objects.equals(this.instanceStatesStrings(), other.instanceStatesStrings()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.instanceGroupId() != null) {
            sb.append("InstanceGroupId: ").append(this.instanceGroupId()).append(",");
        }
        if (this.instanceGroupTypesStrings() != null) {
            sb.append("InstanceGroupTypes: ").append(this.instanceGroupTypesStrings()).append(",");
        }
        if (this.instanceFleetId() != null) {
            sb.append("InstanceFleetId: ").append(this.instanceFleetId()).append(",");
        }
        if (this.instanceFleetTypeString() != null) {
            sb.append("InstanceFleetType: ").append(this.instanceFleetTypeString()).append(",");
        }
        if (this.instanceStatesStrings() != null) {
            sb.append("InstanceStates: ").append(this.instanceStatesStrings()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "InstanceGroupId": {
                return Optional.of(clazz.cast(this.instanceGroupId()));
            }
            case "InstanceGroupTypes": {
                return Optional.of(clazz.cast(this.instanceGroupTypesStrings()));
            }
            case "InstanceFleetId": {
                return Optional.of(clazz.cast(this.instanceFleetId()));
            }
            case "InstanceFleetType": {
                return Optional.of(clazz.cast(this.instanceFleetTypeString()));
            }
            case "InstanceStates": {
                return Optional.of(clazz.cast(this.instanceStatesStrings()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private String instanceGroupId;
        private List<String> instanceGroupTypes;
        private String instanceFleetId;
        private String instanceFleetType;
        private List<String> instanceStates;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesRequest model) {
            this.clusterId(model.clusterId);
            this.instanceGroupId(model.instanceGroupId);
            this.instanceGroupTypes(model.instanceGroupTypes);
            this.instanceFleetId(model.instanceFleetId);
            this.instanceFleetType(model.instanceFleetType);
            this.instanceStates(model.instanceStates);
            this.marker(model.marker);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final Collection<String> getInstanceGroupTypes() {
            return this.instanceGroupTypes;
        }

        @Override
        public final Builder instanceGroupTypes(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupTypes(String ... instanceGroupTypes) {
            this.instanceGroupTypes(Arrays.asList(instanceGroupTypes));
            return this;
        }

        public final void setInstanceGroupTypes(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        public final String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
            return this;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        public final Collection<String> getInstanceStates() {
            return this.instanceStates;
        }

        @Override
        public final Builder instanceStates(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(String ... instanceStates) {
            this.instanceStates(Arrays.asList(instanceStates));
            return this;
        }

        public final void setInstanceStates(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListInstancesRequest build() {
            return new ListInstancesRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, ListInstancesRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroupId(String var1);

        public Builder instanceGroupTypes(Collection<String> var1);

        public Builder instanceGroupTypes(String ... var1);

        public Builder instanceFleetId(String var1);

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder instanceStates(Collection<String> var1);

        public Builder instanceStates(String ... var1);

        public Builder marker(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

