/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsBlockDevice;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceListCopier;
import software.amazon.awssdk.services.emr.transform.InstanceTypeSpecificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceTypeSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceTypeSpecification> {
    private final String instanceType;
    private final Integer weightedCapacity;
    private final String bidPrice;
    private final Double bidPriceAsPercentageOfOnDemandPrice;
    private final List<Configuration> configurations;
    private final List<EbsBlockDevice> ebsBlockDevices;
    private final Boolean ebsOptimized;

    private InstanceTypeSpecification(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.weightedCapacity = builder.weightedCapacity;
        this.bidPrice = builder.bidPrice;
        this.bidPriceAsPercentageOfOnDemandPrice = builder.bidPriceAsPercentageOfOnDemandPrice;
        this.configurations = builder.configurations;
        this.ebsBlockDevices = builder.ebsBlockDevices;
        this.ebsOptimized = builder.ebsOptimized;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer weightedCapacity() {
        return this.weightedCapacity;
    }

    public String bidPrice() {
        return this.bidPrice;
    }

    public Double bidPriceAsPercentageOfOnDemandPrice() {
        return this.bidPriceAsPercentageOfOnDemandPrice;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public List<EbsBlockDevice> ebsBlockDevices() {
        return this.ebsBlockDevices;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPriceAsPercentageOfOnDemandPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsBlockDevices());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeSpecification)) {
            return false;
        }
        InstanceTypeSpecification other = (InstanceTypeSpecification)obj;
        return Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.bidPrice(), other.bidPrice()) && Objects.equals(this.bidPriceAsPercentageOfOnDemandPrice(), other.bidPriceAsPercentageOfOnDemandPrice()) && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.ebsBlockDevices(), other.ebsBlockDevices()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.weightedCapacity() != null) {
            sb.append("WeightedCapacity: ").append(this.weightedCapacity()).append(",");
        }
        if (this.bidPrice() != null) {
            sb.append("BidPrice: ").append(this.bidPrice()).append(",");
        }
        if (this.bidPriceAsPercentageOfOnDemandPrice() != null) {
            sb.append("BidPriceAsPercentageOfOnDemandPrice: ").append(this.bidPriceAsPercentageOfOnDemandPrice()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (this.ebsBlockDevices() != null) {
            sb.append("EbsBlockDevices: ").append(this.ebsBlockDevices()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "WeightedCapacity": {
                return Optional.of(clazz.cast(this.weightedCapacity()));
            }
            case "BidPrice": {
                return Optional.of(clazz.cast(this.bidPrice()));
            }
            case "BidPriceAsPercentageOfOnDemandPrice": {
                return Optional.of(clazz.cast(this.bidPriceAsPercentageOfOnDemandPrice()));
            }
            case "Configurations": {
                return Optional.of(clazz.cast(this.configurations()));
            }
            case "EbsBlockDevices": {
                return Optional.of(clazz.cast(this.ebsBlockDevices()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceTypeSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer weightedCapacity;
        private String bidPrice;
        private Double bidPriceAsPercentageOfOnDemandPrice;
        private List<Configuration> configurations;
        private List<EbsBlockDevice> ebsBlockDevices;
        private Boolean ebsOptimized;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeSpecification model) {
            this.instanceType(model.instanceType);
            this.weightedCapacity(model.weightedCapacity);
            this.bidPrice(model.bidPrice);
            this.bidPriceAsPercentageOfOnDemandPrice(model.bidPriceAsPercentageOfOnDemandPrice);
            this.configurations(model.configurations);
            this.ebsBlockDevices(model.ebsBlockDevices);
            this.ebsOptimized(model.ebsOptimized);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getWeightedCapacity() {
            return this.weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        public final Double getBidPriceAsPercentageOfOnDemandPrice() {
            return this.bidPriceAsPercentageOfOnDemandPrice;
        }

        @Override
        public final Builder bidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
            return this;
        }

        public final void setBidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final Collection<EbsBlockDevice.Builder> getEbsBlockDevices() {
            return this.ebsBlockDevices != null ? (Collection)this.ebsBlockDevices.stream().map(EbsBlockDevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ebsBlockDevices(Collection<EbsBlockDevice> ebsBlockDevices) {
            this.ebsBlockDevices = EbsBlockDeviceListCopier.copy(ebsBlockDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDevices(EbsBlockDevice ... ebsBlockDevices) {
            this.ebsBlockDevices(Arrays.asList(ebsBlockDevices));
            return this;
        }

        public final void setEbsBlockDevices(Collection<EbsBlockDevice.BuilderImpl> ebsBlockDevices) {
            this.ebsBlockDevices = EbsBlockDeviceListCopier.copyFromBuilder(ebsBlockDevices);
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public InstanceTypeSpecification build() {
            return new InstanceTypeSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceTypeSpecification> {
        public Builder instanceType(String var1);

        public Builder weightedCapacity(Integer var1);

        public Builder bidPrice(String var1);

        public Builder bidPriceAsPercentageOfOnDemandPrice(Double var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder ebsBlockDevices(Collection<EbsBlockDevice> var1);

        public Builder ebsBlockDevices(EbsBlockDevice ... var1);

        public Builder ebsOptimized(Boolean var1);
    }
}

