/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.transform.InstanceFleetModifyConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceFleetModifyConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceFleetModifyConfig> {
    private final String instanceFleetId;
    private final Integer targetOnDemandCapacity;
    private final Integer targetSpotCapacity;

    private InstanceFleetModifyConfig(BuilderImpl builder) {
        this.instanceFleetId = builder.instanceFleetId;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
    }

    public String instanceFleetId() {
        return this.instanceFleetId;
    }

    public Integer targetOnDemandCapacity() {
        return this.targetOnDemandCapacity;
    }

    public Integer targetSpotCapacity() {
        return this.targetSpotCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSpotCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetModifyConfig)) {
            return false;
        }
        InstanceFleetModifyConfig other = (InstanceFleetModifyConfig)obj;
        return Objects.equals(this.instanceFleetId(), other.instanceFleetId()) && Objects.equals(this.targetOnDemandCapacity(), other.targetOnDemandCapacity()) && Objects.equals(this.targetSpotCapacity(), other.targetSpotCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceFleetId() != null) {
            sb.append("InstanceFleetId: ").append(this.instanceFleetId()).append(",");
        }
        if (this.targetOnDemandCapacity() != null) {
            sb.append("TargetOnDemandCapacity: ").append(this.targetOnDemandCapacity()).append(",");
        }
        if (this.targetSpotCapacity() != null) {
            sb.append("TargetSpotCapacity: ").append(this.targetSpotCapacity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceFleetId": {
                return Optional.of(clazz.cast(this.instanceFleetId()));
            }
            case "TargetOnDemandCapacity": {
                return Optional.of(clazz.cast(this.targetOnDemandCapacity()));
            }
            case "TargetSpotCapacity": {
                return Optional.of(clazz.cast(this.targetSpotCapacity()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceFleetModifyConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceFleetId;
        private Integer targetOnDemandCapacity;
        private Integer targetSpotCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetModifyConfig model) {
            this.instanceFleetId(model.instanceFleetId);
            this.targetOnDemandCapacity(model.targetOnDemandCapacity);
            this.targetSpotCapacity(model.targetSpotCapacity);
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        public final Integer getTargetOnDemandCapacity() {
            return this.targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        public final Integer getTargetSpotCapacity() {
            return this.targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        public InstanceFleetModifyConfig build() {
            return new InstanceFleetModifyConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceFleetModifyConfig> {
        public Builder instanceFleetId(String var1);

        public Builder targetOnDemandCapacity(Integer var1);

        public Builder targetSpotCapacity(Integer var1);
    }
}

