/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfig;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfigListCopier;
import software.amazon.awssdk.services.emr.transform.InstanceFleetConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceFleetConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceFleetConfig> {
    private final String name;
    private final String instanceFleetType;
    private final Integer targetOnDemandCapacity;
    private final Integer targetSpotCapacity;
    private final List<InstanceTypeConfig> instanceTypeConfigs;
    private final InstanceFleetProvisioningSpecifications launchSpecifications;

    private InstanceFleetConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceFleetType = builder.instanceFleetType;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
        this.instanceTypeConfigs = builder.instanceTypeConfigs;
        this.launchSpecifications = builder.launchSpecifications;
    }

    public String name() {
        return this.name;
    }

    public InstanceFleetType instanceFleetType() {
        return InstanceFleetType.fromValue(this.instanceFleetType);
    }

    public String instanceFleetTypeString() {
        return this.instanceFleetType;
    }

    public Integer targetOnDemandCapacity() {
        return this.targetOnDemandCapacity;
    }

    public Integer targetSpotCapacity() {
        return this.targetSpotCapacity;
    }

    public List<InstanceTypeConfig> instanceTypeConfigs() {
        return this.instanceTypeConfigs;
    }

    public InstanceFleetProvisioningSpecifications launchSpecifications() {
        return this.launchSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSpotCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetConfig)) {
            return false;
        }
        InstanceFleetConfig other = (InstanceFleetConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.instanceFleetTypeString(), other.instanceFleetTypeString()) && Objects.equals(this.targetOnDemandCapacity(), other.targetOnDemandCapacity()) && Objects.equals(this.targetSpotCapacity(), other.targetSpotCapacity()) && Objects.equals(this.instanceTypeConfigs(), other.instanceTypeConfigs()) && Objects.equals(this.launchSpecifications(), other.launchSpecifications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.instanceFleetTypeString() != null) {
            sb.append("InstanceFleetType: ").append(this.instanceFleetTypeString()).append(",");
        }
        if (this.targetOnDemandCapacity() != null) {
            sb.append("TargetOnDemandCapacity: ").append(this.targetOnDemandCapacity()).append(",");
        }
        if (this.targetSpotCapacity() != null) {
            sb.append("TargetSpotCapacity: ").append(this.targetSpotCapacity()).append(",");
        }
        if (this.instanceTypeConfigs() != null) {
            sb.append("InstanceTypeConfigs: ").append(this.instanceTypeConfigs()).append(",");
        }
        if (this.launchSpecifications() != null) {
            sb.append("LaunchSpecifications: ").append(this.launchSpecifications()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "InstanceFleetType": {
                return Optional.of(clazz.cast(this.instanceFleetTypeString()));
            }
            case "TargetOnDemandCapacity": {
                return Optional.of(clazz.cast(this.targetOnDemandCapacity()));
            }
            case "TargetSpotCapacity": {
                return Optional.of(clazz.cast(this.targetSpotCapacity()));
            }
            case "InstanceTypeConfigs": {
                return Optional.of(clazz.cast(this.instanceTypeConfigs()));
            }
            case "LaunchSpecifications": {
                return Optional.of(clazz.cast(this.launchSpecifications()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceFleetConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String instanceFleetType;
        private Integer targetOnDemandCapacity;
        private Integer targetSpotCapacity;
        private List<InstanceTypeConfig> instanceTypeConfigs;
        private InstanceFleetProvisioningSpecifications launchSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetConfig model) {
            this.name(model.name);
            this.instanceFleetType(model.instanceFleetType);
            this.targetOnDemandCapacity(model.targetOnDemandCapacity);
            this.targetSpotCapacity(model.targetSpotCapacity);
            this.instanceTypeConfigs(model.instanceTypeConfigs);
            this.launchSpecifications(model.launchSpecifications);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
            return this;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        public final Integer getTargetOnDemandCapacity() {
            return this.targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        public final Integer getTargetSpotCapacity() {
            return this.targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        public final Collection<InstanceTypeConfig.Builder> getInstanceTypeConfigs() {
            return this.instanceTypeConfigs != null ? (Collection)this.instanceTypeConfigs.stream().map(InstanceTypeConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceTypeConfigs(Collection<InstanceTypeConfig> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copy(instanceTypeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeConfigs(InstanceTypeConfig ... instanceTypeConfigs) {
            this.instanceTypeConfigs(Arrays.asList(instanceTypeConfigs));
            return this;
        }

        public final void setInstanceTypeConfigs(Collection<InstanceTypeConfig.BuilderImpl> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copyFromBuilder(instanceTypeConfigs);
        }

        public final InstanceFleetProvisioningSpecifications.Builder getLaunchSpecifications() {
            return this.launchSpecifications != null ? this.launchSpecifications.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecifications(InstanceFleetProvisioningSpecifications launchSpecifications) {
            this.launchSpecifications = launchSpecifications;
            return this;
        }

        public final void setLaunchSpecifications(InstanceFleetProvisioningSpecifications.BuilderImpl launchSpecifications) {
            this.launchSpecifications = launchSpecifications != null ? launchSpecifications.build() : null;
        }

        public InstanceFleetConfig build() {
            return new InstanceFleetConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceFleetConfig> {
        public Builder name(String var1);

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder targetOnDemandCapacity(Integer var1);

        public Builder targetSpotCapacity(Integer var1);

        public Builder instanceTypeConfigs(Collection<InstanceTypeConfig> var1);

        public Builder instanceTypeConfigs(InstanceTypeConfig ... var1);

        public Builder launchSpecifications(InstanceFleetProvisioningSpecifications var1);

        default public Builder launchSpecifications(Consumer<InstanceFleetProvisioningSpecifications.Builder> launchSpecifications) {
            return this.launchSpecifications((InstanceFleetProvisioningSpecifications)((InstanceFleetProvisioningSpecifications.Builder)InstanceFleetProvisioningSpecifications.builder().apply(launchSpecifications)).build());
        }
    }
}

