/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.HadoopStepConfig;

@SdkInternalApi
public class HadoopStepConfigMarshaller {
    private static final MarshallingInfo<String> JAR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Jar").build();
    private static final MarshallingInfo<Map> PROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Properties").build();
    private static final MarshallingInfo<String> MAINCLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MainClass").build();
    private static final MarshallingInfo<List> ARGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Args").build();
    private static final HadoopStepConfigMarshaller INSTANCE = new HadoopStepConfigMarshaller();

    public static HadoopStepConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HadoopStepConfig hadoopStepConfig, ProtocolMarshaller protocolMarshaller) {
        if (hadoopStepConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hadoopStepConfig.jar(), JAR_BINDING);
            protocolMarshaller.marshall(hadoopStepConfig.properties(), PROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)hadoopStepConfig.mainClass(), MAINCLASS_BINDING);
            protocolMarshaller.marshall(hadoopStepConfig.args(), ARGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

