/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.EbsConfiguration;

@SdkInternalApi
public class EbsConfigurationMarshaller {
    private static final MarshallingInfo<List> EBSBLOCKDEVICECONFIGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsBlockDeviceConfigs").build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").build();
    private static final EbsConfigurationMarshaller INSTANCE = new EbsConfigurationMarshaller();

    public static EbsConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EbsConfiguration ebsConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (ebsConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(ebsConfiguration.ebsBlockDeviceConfigs(), EBSBLOCKDEVICECONFIGS_BINDING);
            protocolMarshaller.marshall((Object)ebsConfiguration.ebsOptimized(), EBSOPTIMIZED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

