/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StepExecutionState;
import software.amazon.awssdk.services.emr.transform.StepExecutionStatusDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepExecutionStatusDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, StepExecutionStatusDetail> {
    private final String state;
    private final Instant creationDateTime;
    private final Instant startDateTime;
    private final Instant endDateTime;
    private final String lastStateChangeReason;

    private StepExecutionStatusDetail(BuilderImpl builder) {
        this.state = builder.state;
        this.creationDateTime = builder.creationDateTime;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.lastStateChangeReason = builder.lastStateChangeReason;
    }

    public StepExecutionState state() {
        return StepExecutionState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Instant startDateTime() {
        return this.startDateTime;
    }

    public Instant endDateTime() {
        return this.endDateTime;
    }

    public String lastStateChangeReason() {
        return this.lastStateChangeReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.creationDateTime() == null ? 0 : this.creationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.startDateTime() == null ? 0 : this.startDateTime().hashCode());
        hashCode = 31 * hashCode + (this.endDateTime() == null ? 0 : this.endDateTime().hashCode());
        hashCode = 31 * hashCode + (this.lastStateChangeReason() == null ? 0 : this.lastStateChangeReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepExecutionStatusDetail)) {
            return false;
        }
        StepExecutionStatusDetail other = (StepExecutionStatusDetail)obj;
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.creationDateTime() == null ^ this.creationDateTime() == null) {
            return false;
        }
        if (other.creationDateTime() != null && !other.creationDateTime().equals(this.creationDateTime())) {
            return false;
        }
        if (other.startDateTime() == null ^ this.startDateTime() == null) {
            return false;
        }
        if (other.startDateTime() != null && !other.startDateTime().equals(this.startDateTime())) {
            return false;
        }
        if (other.endDateTime() == null ^ this.endDateTime() == null) {
            return false;
        }
        if (other.endDateTime() != null && !other.endDateTime().equals(this.endDateTime())) {
            return false;
        }
        if (other.lastStateChangeReason() == null ^ this.lastStateChangeReason() == null) {
            return false;
        }
        return other.lastStateChangeReason() == null || other.lastStateChangeReason().equals(this.lastStateChangeReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.creationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.creationDateTime()).append(",");
        }
        if (this.startDateTime() != null) {
            sb.append("StartDateTime: ").append(this.startDateTime()).append(",");
        }
        if (this.endDateTime() != null) {
            sb.append("EndDateTime: ").append(this.endDateTime()).append(",");
        }
        if (this.lastStateChangeReason() != null) {
            sb.append("LastStateChangeReason: ").append(this.lastStateChangeReason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "CreationDateTime": {
                return Optional.of(clazz.cast(this.creationDateTime()));
            }
            case "StartDateTime": {
                return Optional.of(clazz.cast(this.startDateTime()));
            }
            case "EndDateTime": {
                return Optional.of(clazz.cast(this.endDateTime()));
            }
            case "LastStateChangeReason": {
                return Optional.of(clazz.cast(this.lastStateChangeReason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepExecutionStatusDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private Instant creationDateTime;
        private Instant startDateTime;
        private Instant endDateTime;
        private String lastStateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StepExecutionStatusDetail model) {
            this.state(model.state);
            this.creationDateTime(model.creationDateTime);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
            this.lastStateChangeReason(model.lastStateChangeReason);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StepExecutionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        public final String getLastStateChangeReason() {
            return this.lastStateChangeReason;
        }

        @Override
        public final Builder lastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
            return this;
        }

        public final void setLastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
        }

        public StepExecutionStatusDetail build() {
            return new StepExecutionStatusDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepExecutionStatusDetail> {
        public Builder state(String var1);

        public Builder state(StepExecutionState var1);

        public Builder creationDateTime(Instant var1);

        public Builder startDateTime(Instant var1);

        public Builder endDateTime(Instant var1);

        public Builder lastStateChangeReason(String var1);
    }
}

