/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.InstanceFleetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInstanceFleetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListInstanceFleetsResponse> {
    private final List<InstanceFleet> instanceFleets;
    private final String marker;

    private ListInstanceFleetsResponse(BuilderImpl builder) {
        this.instanceFleets = builder.instanceFleets;
        this.marker = builder.marker;
    }

    public List<InstanceFleet> instanceFleets() {
        return this.instanceFleets;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceFleets() == null ? 0 : this.instanceFleets().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceFleetsResponse)) {
            return false;
        }
        ListInstanceFleetsResponse other = (ListInstanceFleetsResponse)((Object)obj);
        if (other.instanceFleets() == null ^ this.instanceFleets() == null) {
            return false;
        }
        if (other.instanceFleets() != null && !other.instanceFleets().equals(this.instanceFleets())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceFleets() != null) {
            sb.append("InstanceFleets: ").append(this.instanceFleets()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceFleets": {
                return Optional.of(clazz.cast(this.instanceFleets()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceFleet> instanceFleets;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceFleetsResponse model) {
            this.instanceFleets(model.instanceFleets);
            this.marker(model.marker);
        }

        public final Collection<InstanceFleet.Builder> getInstanceFleets() {
            return this.instanceFleets != null ? (Collection)this.instanceFleets.stream().map(InstanceFleet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceFleets(Collection<InstanceFleet> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copy(instanceFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(InstanceFleet ... instanceFleets) {
            this.instanceFleets(Arrays.asList(instanceFleets));
            return this;
        }

        public final void setInstanceFleets(Collection<InstanceFleet.BuilderImpl> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copyFromBuilder(instanceFleets);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListInstanceFleetsResponse build() {
            return new ListInstanceFleetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListInstanceFleetsResponse> {
        public Builder instanceFleets(Collection<InstanceFleet> var1);

        public Builder instanceFleets(InstanceFleet ... var1);

        public Builder marker(String var1);
    }
}

