/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.emr.model.Command;
import software.amazon.awssdk.services.emr.model.CommandListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBootstrapActionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListBootstrapActionsResponse> {
    private final List<Command> bootstrapActions;
    private final String marker;

    private ListBootstrapActionsResponse(BuilderImpl builder) {
        this.bootstrapActions = builder.bootstrapActions;
        this.marker = builder.marker;
    }

    public List<Command> bootstrapActions() {
        return this.bootstrapActions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bootstrapActions() == null ? 0 : this.bootstrapActions().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBootstrapActionsResponse)) {
            return false;
        }
        ListBootstrapActionsResponse other = (ListBootstrapActionsResponse)((Object)obj);
        if (other.bootstrapActions() == null ^ this.bootstrapActions() == null) {
            return false;
        }
        if (other.bootstrapActions() != null && !other.bootstrapActions().equals(this.bootstrapActions())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bootstrapActions() != null) {
            sb.append("BootstrapActions: ").append(this.bootstrapActions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BootstrapActions": {
                return Optional.of(clazz.cast(this.bootstrapActions()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Command> bootstrapActions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBootstrapActionsResponse model) {
            this.bootstrapActions(model.bootstrapActions);
            this.marker(model.marker);
        }

        public final Collection<Command.Builder> getBootstrapActions() {
            return this.bootstrapActions != null ? (Collection)this.bootstrapActions.stream().map(Command::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bootstrapActions(Collection<Command> bootstrapActions) {
            this.bootstrapActions = CommandListCopier.copy(bootstrapActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(Command ... bootstrapActions) {
            this.bootstrapActions(Arrays.asList(bootstrapActions));
            return this;
        }

        public final void setBootstrapActions(Collection<Command.BuilderImpl> bootstrapActions) {
            this.bootstrapActions = CommandListCopier.copyFromBuilder(bootstrapActions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListBootstrapActionsResponse build() {
            return new ListBootstrapActionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBootstrapActionsResponse> {
        public Builder bootstrapActions(Collection<Command> var1);

        public Builder bootstrapActions(Command ... var1);

        public Builder marker(String var1);
    }
}

