/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceFleetConfig;
import software.amazon.awssdk.services.emr.model.InstanceFleetConfigListCopier;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfig;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfigListCopier;
import software.amazon.awssdk.services.emr.model.PlacementType;
import software.amazon.awssdk.services.emr.model.SecurityGroupsListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringMaxLen256ListCopier;
import software.amazon.awssdk.services.emr.transform.JobFlowInstancesConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobFlowInstancesConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, JobFlowInstancesConfig> {
    private final String masterInstanceType;
    private final String slaveInstanceType;
    private final Integer instanceCount;
    private final List<InstanceGroupConfig> instanceGroups;
    private final List<InstanceFleetConfig> instanceFleets;
    private final String ec2KeyName;
    private final PlacementType placement;
    private final Boolean keepJobFlowAliveWhenNoSteps;
    private final Boolean terminationProtected;
    private final String hadoopVersion;
    private final String ec2SubnetId;
    private final List<String> ec2SubnetIds;
    private final String emrManagedMasterSecurityGroup;
    private final String emrManagedSlaveSecurityGroup;
    private final String serviceAccessSecurityGroup;
    private final List<String> additionalMasterSecurityGroups;
    private final List<String> additionalSlaveSecurityGroups;

    private JobFlowInstancesConfig(BuilderImpl builder) {
        this.masterInstanceType = builder.masterInstanceType;
        this.slaveInstanceType = builder.slaveInstanceType;
        this.instanceCount = builder.instanceCount;
        this.instanceGroups = builder.instanceGroups;
        this.instanceFleets = builder.instanceFleets;
        this.ec2KeyName = builder.ec2KeyName;
        this.placement = builder.placement;
        this.keepJobFlowAliveWhenNoSteps = builder.keepJobFlowAliveWhenNoSteps;
        this.terminationProtected = builder.terminationProtected;
        this.hadoopVersion = builder.hadoopVersion;
        this.ec2SubnetId = builder.ec2SubnetId;
        this.ec2SubnetIds = builder.ec2SubnetIds;
        this.emrManagedMasterSecurityGroup = builder.emrManagedMasterSecurityGroup;
        this.emrManagedSlaveSecurityGroup = builder.emrManagedSlaveSecurityGroup;
        this.serviceAccessSecurityGroup = builder.serviceAccessSecurityGroup;
        this.additionalMasterSecurityGroups = builder.additionalMasterSecurityGroups;
        this.additionalSlaveSecurityGroups = builder.additionalSlaveSecurityGroups;
    }

    public String masterInstanceType() {
        return this.masterInstanceType;
    }

    public String slaveInstanceType() {
        return this.slaveInstanceType;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public List<InstanceGroupConfig> instanceGroups() {
        return this.instanceGroups;
    }

    public List<InstanceFleetConfig> instanceFleets() {
        return this.instanceFleets;
    }

    public String ec2KeyName() {
        return this.ec2KeyName;
    }

    public PlacementType placement() {
        return this.placement;
    }

    public Boolean keepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public Boolean terminationProtected() {
        return this.terminationProtected;
    }

    public String hadoopVersion() {
        return this.hadoopVersion;
    }

    public String ec2SubnetId() {
        return this.ec2SubnetId;
    }

    public List<String> ec2SubnetIds() {
        return this.ec2SubnetIds;
    }

    public String emrManagedMasterSecurityGroup() {
        return this.emrManagedMasterSecurityGroup;
    }

    public String emrManagedSlaveSecurityGroup() {
        return this.emrManagedSlaveSecurityGroup;
    }

    public String serviceAccessSecurityGroup() {
        return this.serviceAccessSecurityGroup;
    }

    public List<String> additionalMasterSecurityGroups() {
        return this.additionalMasterSecurityGroups;
    }

    public List<String> additionalSlaveSecurityGroups() {
        return this.additionalSlaveSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.masterInstanceType() == null ? 0 : this.masterInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.slaveInstanceType() == null ? 0 : this.slaveInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.instanceGroups() == null ? 0 : this.instanceGroups().hashCode());
        hashCode = 31 * hashCode + (this.instanceFleets() == null ? 0 : this.instanceFleets().hashCode());
        hashCode = 31 * hashCode + (this.ec2KeyName() == null ? 0 : this.ec2KeyName().hashCode());
        hashCode = 31 * hashCode + (this.placement() == null ? 0 : this.placement().hashCode());
        hashCode = 31 * hashCode + (this.keepJobFlowAliveWhenNoSteps() == null ? 0 : this.keepJobFlowAliveWhenNoSteps().hashCode());
        hashCode = 31 * hashCode + (this.terminationProtected() == null ? 0 : this.terminationProtected().hashCode());
        hashCode = 31 * hashCode + (this.hadoopVersion() == null ? 0 : this.hadoopVersion().hashCode());
        hashCode = 31 * hashCode + (this.ec2SubnetId() == null ? 0 : this.ec2SubnetId().hashCode());
        hashCode = 31 * hashCode + (this.ec2SubnetIds() == null ? 0 : this.ec2SubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.emrManagedMasterSecurityGroup() == null ? 0 : this.emrManagedMasterSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.emrManagedSlaveSecurityGroup() == null ? 0 : this.emrManagedSlaveSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.serviceAccessSecurityGroup() == null ? 0 : this.serviceAccessSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.additionalMasterSecurityGroups() == null ? 0 : this.additionalMasterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.additionalSlaveSecurityGroups() == null ? 0 : this.additionalSlaveSecurityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowInstancesConfig)) {
            return false;
        }
        JobFlowInstancesConfig other = (JobFlowInstancesConfig)obj;
        if (other.masterInstanceType() == null ^ this.masterInstanceType() == null) {
            return false;
        }
        if (other.masterInstanceType() != null && !other.masterInstanceType().equals(this.masterInstanceType())) {
            return false;
        }
        if (other.slaveInstanceType() == null ^ this.slaveInstanceType() == null) {
            return false;
        }
        if (other.slaveInstanceType() != null && !other.slaveInstanceType().equals(this.slaveInstanceType())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.instanceGroups() == null ^ this.instanceGroups() == null) {
            return false;
        }
        if (other.instanceGroups() != null && !other.instanceGroups().equals(this.instanceGroups())) {
            return false;
        }
        if (other.instanceFleets() == null ^ this.instanceFleets() == null) {
            return false;
        }
        if (other.instanceFleets() != null && !other.instanceFleets().equals(this.instanceFleets())) {
            return false;
        }
        if (other.ec2KeyName() == null ^ this.ec2KeyName() == null) {
            return false;
        }
        if (other.ec2KeyName() != null && !other.ec2KeyName().equals(this.ec2KeyName())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.keepJobFlowAliveWhenNoSteps() == null ^ this.keepJobFlowAliveWhenNoSteps() == null) {
            return false;
        }
        if (other.keepJobFlowAliveWhenNoSteps() != null && !other.keepJobFlowAliveWhenNoSteps().equals(this.keepJobFlowAliveWhenNoSteps())) {
            return false;
        }
        if (other.terminationProtected() == null ^ this.terminationProtected() == null) {
            return false;
        }
        if (other.terminationProtected() != null && !other.terminationProtected().equals(this.terminationProtected())) {
            return false;
        }
        if (other.hadoopVersion() == null ^ this.hadoopVersion() == null) {
            return false;
        }
        if (other.hadoopVersion() != null && !other.hadoopVersion().equals(this.hadoopVersion())) {
            return false;
        }
        if (other.ec2SubnetId() == null ^ this.ec2SubnetId() == null) {
            return false;
        }
        if (other.ec2SubnetId() != null && !other.ec2SubnetId().equals(this.ec2SubnetId())) {
            return false;
        }
        if (other.ec2SubnetIds() == null ^ this.ec2SubnetIds() == null) {
            return false;
        }
        if (other.ec2SubnetIds() != null && !other.ec2SubnetIds().equals(this.ec2SubnetIds())) {
            return false;
        }
        if (other.emrManagedMasterSecurityGroup() == null ^ this.emrManagedMasterSecurityGroup() == null) {
            return false;
        }
        if (other.emrManagedMasterSecurityGroup() != null && !other.emrManagedMasterSecurityGroup().equals(this.emrManagedMasterSecurityGroup())) {
            return false;
        }
        if (other.emrManagedSlaveSecurityGroup() == null ^ this.emrManagedSlaveSecurityGroup() == null) {
            return false;
        }
        if (other.emrManagedSlaveSecurityGroup() != null && !other.emrManagedSlaveSecurityGroup().equals(this.emrManagedSlaveSecurityGroup())) {
            return false;
        }
        if (other.serviceAccessSecurityGroup() == null ^ this.serviceAccessSecurityGroup() == null) {
            return false;
        }
        if (other.serviceAccessSecurityGroup() != null && !other.serviceAccessSecurityGroup().equals(this.serviceAccessSecurityGroup())) {
            return false;
        }
        if (other.additionalMasterSecurityGroups() == null ^ this.additionalMasterSecurityGroups() == null) {
            return false;
        }
        if (other.additionalMasterSecurityGroups() != null && !other.additionalMasterSecurityGroups().equals(this.additionalMasterSecurityGroups())) {
            return false;
        }
        if (other.additionalSlaveSecurityGroups() == null ^ this.additionalSlaveSecurityGroups() == null) {
            return false;
        }
        return other.additionalSlaveSecurityGroups() == null || other.additionalSlaveSecurityGroups().equals(this.additionalSlaveSecurityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.masterInstanceType() != null) {
            sb.append("MasterInstanceType: ").append(this.masterInstanceType()).append(",");
        }
        if (this.slaveInstanceType() != null) {
            sb.append("SlaveInstanceType: ").append(this.slaveInstanceType()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.instanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.instanceGroups()).append(",");
        }
        if (this.instanceFleets() != null) {
            sb.append("InstanceFleets: ").append(this.instanceFleets()).append(",");
        }
        if (this.ec2KeyName() != null) {
            sb.append("Ec2KeyName: ").append(this.ec2KeyName()).append(",");
        }
        if (this.placement() != null) {
            sb.append("Placement: ").append(this.placement()).append(",");
        }
        if (this.keepJobFlowAliveWhenNoSteps() != null) {
            sb.append("KeepJobFlowAliveWhenNoSteps: ").append(this.keepJobFlowAliveWhenNoSteps()).append(",");
        }
        if (this.terminationProtected() != null) {
            sb.append("TerminationProtected: ").append(this.terminationProtected()).append(",");
        }
        if (this.hadoopVersion() != null) {
            sb.append("HadoopVersion: ").append(this.hadoopVersion()).append(",");
        }
        if (this.ec2SubnetId() != null) {
            sb.append("Ec2SubnetId: ").append(this.ec2SubnetId()).append(",");
        }
        if (this.ec2SubnetIds() != null) {
            sb.append("Ec2SubnetIds: ").append(this.ec2SubnetIds()).append(",");
        }
        if (this.emrManagedMasterSecurityGroup() != null) {
            sb.append("EmrManagedMasterSecurityGroup: ").append(this.emrManagedMasterSecurityGroup()).append(",");
        }
        if (this.emrManagedSlaveSecurityGroup() != null) {
            sb.append("EmrManagedSlaveSecurityGroup: ").append(this.emrManagedSlaveSecurityGroup()).append(",");
        }
        if (this.serviceAccessSecurityGroup() != null) {
            sb.append("ServiceAccessSecurityGroup: ").append(this.serviceAccessSecurityGroup()).append(",");
        }
        if (this.additionalMasterSecurityGroups() != null) {
            sb.append("AdditionalMasterSecurityGroups: ").append(this.additionalMasterSecurityGroups()).append(",");
        }
        if (this.additionalSlaveSecurityGroups() != null) {
            sb.append("AdditionalSlaveSecurityGroups: ").append(this.additionalSlaveSecurityGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MasterInstanceType": {
                return Optional.of(clazz.cast(this.masterInstanceType()));
            }
            case "SlaveInstanceType": {
                return Optional.of(clazz.cast(this.slaveInstanceType()));
            }
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "InstanceGroups": {
                return Optional.of(clazz.cast(this.instanceGroups()));
            }
            case "InstanceFleets": {
                return Optional.of(clazz.cast(this.instanceFleets()));
            }
            case "Ec2KeyName": {
                return Optional.of(clazz.cast(this.ec2KeyName()));
            }
            case "Placement": {
                return Optional.of(clazz.cast(this.placement()));
            }
            case "KeepJobFlowAliveWhenNoSteps": {
                return Optional.of(clazz.cast(this.keepJobFlowAliveWhenNoSteps()));
            }
            case "TerminationProtected": {
                return Optional.of(clazz.cast(this.terminationProtected()));
            }
            case "HadoopVersion": {
                return Optional.of(clazz.cast(this.hadoopVersion()));
            }
            case "Ec2SubnetId": {
                return Optional.of(clazz.cast(this.ec2SubnetId()));
            }
            case "Ec2SubnetIds": {
                return Optional.of(clazz.cast(this.ec2SubnetIds()));
            }
            case "EmrManagedMasterSecurityGroup": {
                return Optional.of(clazz.cast(this.emrManagedMasterSecurityGroup()));
            }
            case "EmrManagedSlaveSecurityGroup": {
                return Optional.of(clazz.cast(this.emrManagedSlaveSecurityGroup()));
            }
            case "ServiceAccessSecurityGroup": {
                return Optional.of(clazz.cast(this.serviceAccessSecurityGroup()));
            }
            case "AdditionalMasterSecurityGroups": {
                return Optional.of(clazz.cast(this.additionalMasterSecurityGroups()));
            }
            case "AdditionalSlaveSecurityGroups": {
                return Optional.of(clazz.cast(this.additionalSlaveSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobFlowInstancesConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String masterInstanceType;
        private String slaveInstanceType;
        private Integer instanceCount;
        private List<InstanceGroupConfig> instanceGroups;
        private List<InstanceFleetConfig> instanceFleets;
        private String ec2KeyName;
        private PlacementType placement;
        private Boolean keepJobFlowAliveWhenNoSteps;
        private Boolean terminationProtected;
        private String hadoopVersion;
        private String ec2SubnetId;
        private List<String> ec2SubnetIds;
        private String emrManagedMasterSecurityGroup;
        private String emrManagedSlaveSecurityGroup;
        private String serviceAccessSecurityGroup;
        private List<String> additionalMasterSecurityGroups;
        private List<String> additionalSlaveSecurityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(JobFlowInstancesConfig model) {
            this.masterInstanceType(model.masterInstanceType);
            this.slaveInstanceType(model.slaveInstanceType);
            this.instanceCount(model.instanceCount);
            this.instanceGroups(model.instanceGroups);
            this.instanceFleets(model.instanceFleets);
            this.ec2KeyName(model.ec2KeyName);
            this.placement(model.placement);
            this.keepJobFlowAliveWhenNoSteps(model.keepJobFlowAliveWhenNoSteps);
            this.terminationProtected(model.terminationProtected);
            this.hadoopVersion(model.hadoopVersion);
            this.ec2SubnetId(model.ec2SubnetId);
            this.ec2SubnetIds(model.ec2SubnetIds);
            this.emrManagedMasterSecurityGroup(model.emrManagedMasterSecurityGroup);
            this.emrManagedSlaveSecurityGroup(model.emrManagedSlaveSecurityGroup);
            this.serviceAccessSecurityGroup(model.serviceAccessSecurityGroup);
            this.additionalMasterSecurityGroups(model.additionalMasterSecurityGroups);
            this.additionalSlaveSecurityGroups(model.additionalSlaveSecurityGroups);
        }

        public final String getMasterInstanceType() {
            return this.masterInstanceType;
        }

        @Override
        public final Builder masterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
            return this;
        }

        public final void setMasterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
        }

        public final String getSlaveInstanceType() {
            return this.slaveInstanceType;
        }

        @Override
        public final Builder slaveInstanceType(String slaveInstanceType) {
            this.slaveInstanceType = slaveInstanceType;
            return this;
        }

        public final void setSlaveInstanceType(String slaveInstanceType) {
            this.slaveInstanceType = slaveInstanceType;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<InstanceGroupConfig.Builder> getInstanceGroups() {
            return this.instanceGroups != null ? (Collection)this.instanceGroups.stream().map(InstanceGroupConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupConfig.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copyFromBuilder(instanceGroups);
        }

        public final Collection<InstanceFleetConfig.Builder> getInstanceFleets() {
            return this.instanceFleets != null ? (Collection)this.instanceFleets.stream().map(InstanceFleetConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceFleets(Collection<InstanceFleetConfig> instanceFleets) {
            this.instanceFleets = InstanceFleetConfigListCopier.copy(instanceFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(InstanceFleetConfig ... instanceFleets) {
            this.instanceFleets(Arrays.asList(instanceFleets));
            return this;
        }

        public final void setInstanceFleets(Collection<InstanceFleetConfig.BuilderImpl> instanceFleets) {
            this.instanceFleets = InstanceFleetConfigListCopier.copyFromBuilder(instanceFleets);
        }

        public final String getEc2KeyName() {
            return this.ec2KeyName;
        }

        @Override
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        public final PlacementType.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(PlacementType placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(PlacementType.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final Boolean getKeepJobFlowAliveWhenNoSteps() {
            return this.keepJobFlowAliveWhenNoSteps;
        }

        @Override
        public final Builder keepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
            return this;
        }

        public final void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
        }

        public final Boolean getTerminationProtected() {
            return this.terminationProtected;
        }

        @Override
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        public final String getHadoopVersion() {
            return this.hadoopVersion;
        }

        @Override
        public final Builder hadoopVersion(String hadoopVersion) {
            this.hadoopVersion = hadoopVersion;
            return this;
        }

        public final void setHadoopVersion(String hadoopVersion) {
            this.hadoopVersion = hadoopVersion;
        }

        public final String getEc2SubnetId() {
            return this.ec2SubnetId;
        }

        @Override
        public final Builder ec2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
            return this;
        }

        public final void setEc2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
        }

        public final Collection<String> getEc2SubnetIds() {
            return this.ec2SubnetIds;
        }

        @Override
        public final Builder ec2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = XmlStringMaxLen256ListCopier.copy(ec2SubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SubnetIds(String ... ec2SubnetIds) {
            this.ec2SubnetIds(Arrays.asList(ec2SubnetIds));
            return this;
        }

        public final void setEc2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = XmlStringMaxLen256ListCopier.copy(ec2SubnetIds);
        }

        public final String getEmrManagedMasterSecurityGroup() {
            return this.emrManagedMasterSecurityGroup;
        }

        @Override
        public final Builder emrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
            return this;
        }

        public final void setEmrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
        }

        public final String getEmrManagedSlaveSecurityGroup() {
            return this.emrManagedSlaveSecurityGroup;
        }

        @Override
        public final Builder emrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
            return this;
        }

        public final void setEmrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
        }

        public final String getServiceAccessSecurityGroup() {
            return this.serviceAccessSecurityGroup;
        }

        @Override
        public final Builder serviceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
            return this;
        }

        public final void setServiceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
        }

        public final Collection<String> getAdditionalMasterSecurityGroups() {
            return this.additionalMasterSecurityGroups;
        }

        @Override
        public final Builder additionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = SecurityGroupsListCopier.copy(additionalMasterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMasterSecurityGroups(String ... additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups(Arrays.asList(additionalMasterSecurityGroups));
            return this;
        }

        public final void setAdditionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = SecurityGroupsListCopier.copy(additionalMasterSecurityGroups);
        }

        public final Collection<String> getAdditionalSlaveSecurityGroups() {
            return this.additionalSlaveSecurityGroups;
        }

        @Override
        public final Builder additionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = SecurityGroupsListCopier.copy(additionalSlaveSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSlaveSecurityGroups(String ... additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups(Arrays.asList(additionalSlaveSecurityGroups));
            return this;
        }

        public final void setAdditionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = SecurityGroupsListCopier.copy(additionalSlaveSecurityGroups);
        }

        public JobFlowInstancesConfig build() {
            return new JobFlowInstancesConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobFlowInstancesConfig> {
        public Builder masterInstanceType(String var1);

        public Builder slaveInstanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceGroups(Collection<InstanceGroupConfig> var1);

        public Builder instanceGroups(InstanceGroupConfig ... var1);

        public Builder instanceFleets(Collection<InstanceFleetConfig> var1);

        public Builder instanceFleets(InstanceFleetConfig ... var1);

        public Builder ec2KeyName(String var1);

        public Builder placement(PlacementType var1);

        public Builder keepJobFlowAliveWhenNoSteps(Boolean var1);

        public Builder terminationProtected(Boolean var1);

        public Builder hadoopVersion(String var1);

        public Builder ec2SubnetId(String var1);

        public Builder ec2SubnetIds(Collection<String> var1);

        public Builder ec2SubnetIds(String ... var1);

        public Builder emrManagedMasterSecurityGroup(String var1);

        public Builder emrManagedSlaveSecurityGroup(String var1);

        public Builder serviceAccessSecurityGroup(String var1);

        public Builder additionalMasterSecurityGroups(Collection<String> var1);

        public Builder additionalMasterSecurityGroups(String ... var1);

        public Builder additionalSlaveSecurityGroups(Collection<String> var1);

        public Builder additionalSlaveSecurityGroups(String ... var1);
    }
}

