/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.EC2InstanceIdsListCopier;
import software.amazon.awssdk.services.emr.transform.InstanceResizePolicyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceResizePolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceResizePolicy> {
    private final List<String> instancesToTerminate;
    private final List<String> instancesToProtect;
    private final Integer instanceTerminationTimeout;

    private InstanceResizePolicy(BuilderImpl builder) {
        this.instancesToTerminate = builder.instancesToTerminate;
        this.instancesToProtect = builder.instancesToProtect;
        this.instanceTerminationTimeout = builder.instanceTerminationTimeout;
    }

    public List<String> instancesToTerminate() {
        return this.instancesToTerminate;
    }

    public List<String> instancesToProtect() {
        return this.instancesToProtect;
    }

    public Integer instanceTerminationTimeout() {
        return this.instanceTerminationTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instancesToTerminate() == null ? 0 : this.instancesToTerminate().hashCode());
        hashCode = 31 * hashCode + (this.instancesToProtect() == null ? 0 : this.instancesToProtect().hashCode());
        hashCode = 31 * hashCode + (this.instanceTerminationTimeout() == null ? 0 : this.instanceTerminationTimeout().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceResizePolicy)) {
            return false;
        }
        InstanceResizePolicy other = (InstanceResizePolicy)obj;
        if (other.instancesToTerminate() == null ^ this.instancesToTerminate() == null) {
            return false;
        }
        if (other.instancesToTerminate() != null && !other.instancesToTerminate().equals(this.instancesToTerminate())) {
            return false;
        }
        if (other.instancesToProtect() == null ^ this.instancesToProtect() == null) {
            return false;
        }
        if (other.instancesToProtect() != null && !other.instancesToProtect().equals(this.instancesToProtect())) {
            return false;
        }
        if (other.instanceTerminationTimeout() == null ^ this.instanceTerminationTimeout() == null) {
            return false;
        }
        return other.instanceTerminationTimeout() == null || other.instanceTerminationTimeout().equals(this.instanceTerminationTimeout());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instancesToTerminate() != null) {
            sb.append("InstancesToTerminate: ").append(this.instancesToTerminate()).append(",");
        }
        if (this.instancesToProtect() != null) {
            sb.append("InstancesToProtect: ").append(this.instancesToProtect()).append(",");
        }
        if (this.instanceTerminationTimeout() != null) {
            sb.append("InstanceTerminationTimeout: ").append(this.instanceTerminationTimeout()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstancesToTerminate": {
                return Optional.of(clazz.cast(this.instancesToTerminate()));
            }
            case "InstancesToProtect": {
                return Optional.of(clazz.cast(this.instancesToProtect()));
            }
            case "InstanceTerminationTimeout": {
                return Optional.of(clazz.cast(this.instanceTerminationTimeout()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceResizePolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instancesToTerminate;
        private List<String> instancesToProtect;
        private Integer instanceTerminationTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceResizePolicy model) {
            this.instancesToTerminate(model.instancesToTerminate);
            this.instancesToProtect(model.instancesToProtect);
            this.instanceTerminationTimeout(model.instanceTerminationTimeout);
        }

        public final Collection<String> getInstancesToTerminate() {
            return this.instancesToTerminate;
        }

        @Override
        public final Builder instancesToTerminate(Collection<String> instancesToTerminate) {
            this.instancesToTerminate = EC2InstanceIdsListCopier.copy(instancesToTerminate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesToTerminate(String ... instancesToTerminate) {
            this.instancesToTerminate(Arrays.asList(instancesToTerminate));
            return this;
        }

        public final void setInstancesToTerminate(Collection<String> instancesToTerminate) {
            this.instancesToTerminate = EC2InstanceIdsListCopier.copy(instancesToTerminate);
        }

        public final Collection<String> getInstancesToProtect() {
            return this.instancesToProtect;
        }

        @Override
        public final Builder instancesToProtect(Collection<String> instancesToProtect) {
            this.instancesToProtect = EC2InstanceIdsListCopier.copy(instancesToProtect);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesToProtect(String ... instancesToProtect) {
            this.instancesToProtect(Arrays.asList(instancesToProtect));
            return this;
        }

        public final void setInstancesToProtect(Collection<String> instancesToProtect) {
            this.instancesToProtect = EC2InstanceIdsListCopier.copy(instancesToProtect);
        }

        public final Integer getInstanceTerminationTimeout() {
            return this.instanceTerminationTimeout;
        }

        @Override
        public final Builder instanceTerminationTimeout(Integer instanceTerminationTimeout) {
            this.instanceTerminationTimeout = instanceTerminationTimeout;
            return this;
        }

        public final void setInstanceTerminationTimeout(Integer instanceTerminationTimeout) {
            this.instanceTerminationTimeout = instanceTerminationTimeout;
        }

        public InstanceResizePolicy build() {
            return new InstanceResizePolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceResizePolicy> {
        public Builder instancesToTerminate(Collection<String> var1);

        public Builder instancesToTerminate(String ... var1);

        public Builder instancesToProtect(Collection<String> var1);

        public Builder instancesToProtect(String ... var1);

        public Builder instanceTerminationTimeout(Integer var1);
    }
}

