/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicy;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsConfiguration;
import software.amazon.awssdk.services.emr.model.InstanceRoleType;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.services.emr.transform.InstanceGroupConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceGroupConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceGroupConfig> {
    private final String name;
    private final String market;
    private final String instanceRole;
    private final String bidPrice;
    private final String instanceType;
    private final Integer instanceCount;
    private final List<Configuration> configurations;
    private final EbsConfiguration ebsConfiguration;
    private final AutoScalingPolicy autoScalingPolicy;

    private InstanceGroupConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.market = builder.market;
        this.instanceRole = builder.instanceRole;
        this.bidPrice = builder.bidPrice;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.configurations = builder.configurations;
        this.ebsConfiguration = builder.ebsConfiguration;
        this.autoScalingPolicy = builder.autoScalingPolicy;
    }

    public String name() {
        return this.name;
    }

    public MarketType market() {
        return MarketType.fromValue(this.market);
    }

    public String marketString() {
        return this.market;
    }

    public InstanceRoleType instanceRole() {
        return InstanceRoleType.fromValue(this.instanceRole);
    }

    public String instanceRoleString() {
        return this.instanceRole;
    }

    public String bidPrice() {
        return this.bidPrice;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public EbsConfiguration ebsConfiguration() {
        return this.ebsConfiguration;
    }

    public AutoScalingPolicy autoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.marketString() == null ? 0 : this.marketString().hashCode());
        hashCode = 31 * hashCode + (this.instanceRoleString() == null ? 0 : this.instanceRoleString().hashCode());
        hashCode = 31 * hashCode + (this.bidPrice() == null ? 0 : this.bidPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.configurations() == null ? 0 : this.configurations().hashCode());
        hashCode = 31 * hashCode + (this.ebsConfiguration() == null ? 0 : this.ebsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingPolicy() == null ? 0 : this.autoScalingPolicy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupConfig)) {
            return false;
        }
        InstanceGroupConfig other = (InstanceGroupConfig)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.marketString() == null ^ this.marketString() == null) {
            return false;
        }
        if (other.marketString() != null && !other.marketString().equals(this.marketString())) {
            return false;
        }
        if (other.instanceRoleString() == null ^ this.instanceRoleString() == null) {
            return false;
        }
        if (other.instanceRoleString() != null && !other.instanceRoleString().equals(this.instanceRoleString())) {
            return false;
        }
        if (other.bidPrice() == null ^ this.bidPrice() == null) {
            return false;
        }
        if (other.bidPrice() != null && !other.bidPrice().equals(this.bidPrice())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.configurations() == null ^ this.configurations() == null) {
            return false;
        }
        if (other.configurations() != null && !other.configurations().equals(this.configurations())) {
            return false;
        }
        if (other.ebsConfiguration() == null ^ this.ebsConfiguration() == null) {
            return false;
        }
        if (other.ebsConfiguration() != null && !other.ebsConfiguration().equals(this.ebsConfiguration())) {
            return false;
        }
        if (other.autoScalingPolicy() == null ^ this.autoScalingPolicy() == null) {
            return false;
        }
        return other.autoScalingPolicy() == null || other.autoScalingPolicy().equals(this.autoScalingPolicy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.marketString() != null) {
            sb.append("Market: ").append(this.marketString()).append(",");
        }
        if (this.instanceRoleString() != null) {
            sb.append("InstanceRole: ").append(this.instanceRoleString()).append(",");
        }
        if (this.bidPrice() != null) {
            sb.append("BidPrice: ").append(this.bidPrice()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (this.ebsConfiguration() != null) {
            sb.append("EbsConfiguration: ").append(this.ebsConfiguration()).append(",");
        }
        if (this.autoScalingPolicy() != null) {
            sb.append("AutoScalingPolicy: ").append(this.autoScalingPolicy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Market": {
                return Optional.of(clazz.cast(this.marketString()));
            }
            case "InstanceRole": {
                return Optional.of(clazz.cast(this.instanceRoleString()));
            }
            case "BidPrice": {
                return Optional.of(clazz.cast(this.bidPrice()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "Configurations": {
                return Optional.of(clazz.cast(this.configurations()));
            }
            case "EbsConfiguration": {
                return Optional.of(clazz.cast(this.ebsConfiguration()));
            }
            case "AutoScalingPolicy": {
                return Optional.of(clazz.cast(this.autoScalingPolicy()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceGroupConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String market;
        private String instanceRole;
        private String bidPrice;
        private String instanceType;
        private Integer instanceCount;
        private List<Configuration> configurations;
        private EbsConfiguration ebsConfiguration;
        private AutoScalingPolicy autoScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupConfig model) {
            this.name(model.name);
            this.market(model.market);
            this.instanceRole(model.instanceRole);
            this.bidPrice(model.bidPrice);
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.configurations(model.configurations);
            this.ebsConfiguration(model.ebsConfiguration);
            this.autoScalingPolicy(model.autoScalingPolicy);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMarket() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        @Override
        public final Builder instanceRole(InstanceRoleType instanceRole) {
            this.instanceRole(instanceRole.toString());
            return this;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final EbsConfiguration.Builder getEbsConfiguration() {
            return this.ebsConfiguration != null ? this.ebsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder ebsConfiguration(EbsConfiguration ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration;
            return this;
        }

        public final void setEbsConfiguration(EbsConfiguration.BuilderImpl ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration != null ? ebsConfiguration.build() : null;
        }

        public final AutoScalingPolicy.Builder getAutoScalingPolicy() {
            return this.autoScalingPolicy != null ? this.autoScalingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicy.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        public InstanceGroupConfig build() {
            return new InstanceGroupConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceGroupConfig> {
        public Builder name(String var1);

        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder instanceRole(String var1);

        public Builder instanceRole(InstanceRoleType var1);

        public Builder bidPrice(String var1);

        public Builder instanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder ebsConfiguration(EbsConfiguration var1);

        public Builder autoScalingPolicy(AutoScalingPolicy var1);
    }
}

