/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyState;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason;
import software.amazon.awssdk.services.emr.transform.AutoScalingPolicyStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutoScalingPolicyStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingPolicyStatus> {
    private final String state;
    private final AutoScalingPolicyStateChangeReason stateChangeReason;

    private AutoScalingPolicyStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
    }

    public AutoScalingPolicyState state() {
        return AutoScalingPolicyState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public AutoScalingPolicyStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.stateChangeReason() == null ? 0 : this.stateChangeReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyStatus)) {
            return false;
        }
        AutoScalingPolicyStatus other = (AutoScalingPolicyStatus)obj;
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.stateChangeReason() == null ^ this.stateChangeReason() == null) {
            return false;
        }
        return other.stateChangeReason() == null || other.stateChangeReason().equals(this.stateChangeReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.stateChangeReason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StateChangeReason": {
                return Optional.of(clazz.cast(this.stateChangeReason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingPolicyStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private AutoScalingPolicyStateChangeReason stateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AutoScalingPolicyState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final AutoScalingPolicyStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(AutoScalingPolicyStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(AutoScalingPolicyStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public AutoScalingPolicyStatus build() {
            return new AutoScalingPolicyStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingPolicyStatus> {
        public Builder state(String var1);

        public Builder state(AutoScalingPolicyState var1);

        public Builder stateChangeReason(AutoScalingPolicyStateChangeReason var1);
    }
}

