/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.model.StepConfigListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddJobFlowStepsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddJobFlowStepsRequest> {
    private final String jobFlowId;
    private final List<StepConfig> steps;

    private AddJobFlowStepsRequest(BuilderImpl builder) {
        this.jobFlowId = builder.jobFlowId;
        this.steps = builder.steps;
    }

    public String jobFlowId() {
        return this.jobFlowId;
    }

    public List<StepConfig> steps() {
        return this.steps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobFlowId() == null ? 0 : this.jobFlowId().hashCode());
        hashCode = 31 * hashCode + (this.steps() == null ? 0 : this.steps().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddJobFlowStepsRequest)) {
            return false;
        }
        AddJobFlowStepsRequest other = (AddJobFlowStepsRequest)((Object)obj);
        if (other.jobFlowId() == null ^ this.jobFlowId() == null) {
            return false;
        }
        if (other.jobFlowId() != null && !other.jobFlowId().equals(this.jobFlowId())) {
            return false;
        }
        if (other.steps() == null ^ this.steps() == null) {
            return false;
        }
        return other.steps() == null || other.steps().equals(this.steps());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobFlowId() != null) {
            sb.append("JobFlowId: ").append(this.jobFlowId()).append(",");
        }
        if (this.steps() != null) {
            sb.append("Steps: ").append(this.steps()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlowId": {
                return Optional.of(clazz.cast(this.jobFlowId()));
            }
            case "Steps": {
                return Optional.of(clazz.cast(this.steps()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobFlowId;
        private List<StepConfig> steps;

        private BuilderImpl() {
        }

        private BuilderImpl(AddJobFlowStepsRequest model) {
            this.jobFlowId(model.jobFlowId);
            this.steps(model.steps);
        }

        public final String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        public final Collection<StepConfig.Builder> getSteps() {
            return this.steps != null ? (Collection)this.steps.stream().map(StepConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder steps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepConfig ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        public final void setSteps(Collection<StepConfig.BuilderImpl> steps) {
            this.steps = StepConfigListCopier.copyFromBuilder(steps);
        }

        public AddJobFlowStepsRequest build() {
            return new AddJobFlowStepsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddJobFlowStepsRequest> {
        public Builder jobFlowId(String var1);

        public Builder steps(Collection<StepConfig> var1);

        public Builder steps(StepConfig ... var1);
    }
}

