/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfig;

@SdkInternalApi
public class InstanceGroupConfigMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> MARKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Market").build();
    private static final MarshallingInfo<String> INSTANCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceRole").build();
    private static final MarshallingInfo<String> BIDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BidPrice").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").build();
    private static final MarshallingInfo<List> CONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configurations").build();
    private static final MarshallingInfo<StructuredPojo> EBSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> AUTOSCALINGPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingPolicy").build();
    private static final InstanceGroupConfigMarshaller INSTANCE = new InstanceGroupConfigMarshaller();

    public static InstanceGroupConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceGroupConfig instanceGroupConfig, ProtocolMarshaller protocolMarshaller) {
        if (instanceGroupConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceGroupConfig.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.market(), MARKET_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.instanceRole(), INSTANCEROLE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.bidPrice(), BIDPRICE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall(instanceGroupConfig.configurations(), CONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.ebsConfiguration(), EBSCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.autoScalingPolicy(), AUTOSCALINGPOLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

