/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemoveTagsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RemoveTagsRequest> {
    private final String resourceId;
    private final List<String> tagKeys;

    private RemoveTagsRequest(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.tagKeys = builder.tagKeys;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.tagKeys() == null ? 0 : this.tagKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsRequest)) {
            return false;
        }
        RemoveTagsRequest other = (RemoveTagsRequest)((Object)obj);
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        return other.tagKeys() == null || other.tagKeys().equals(this.tagKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private List<String> tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsRequest model) {
            this.setResourceId(model.resourceId);
            this.setTagKeys(model.tagKeys);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = StringListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = StringListCopier.copy(tagKeys);
        }

        public RemoveTagsRequest build() {
            return new RemoveTagsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemoveTagsRequest> {
        public Builder resourceId(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);
    }
}

