/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.emr.model.Instance;
import software.amazon.awssdk.services.emr.model.InstanceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListInstancesResponse> {
    private final List<Instance> instances;
    private final String marker;

    private ListInstancesResponse(BuilderImpl builder) {
        this.instances = builder.instances;
        this.marker = builder.marker;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesResponse)) {
            return false;
        }
        ListInstancesResponse other = (ListInstancesResponse)((Object)obj);
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Instance> instances;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesResponse model) {
            this.setInstances(model.instances);
            this.setMarker(model.marker);
        }

        public final Collection<Instance> getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListInstancesResponse build() {
            return new ListInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListInstancesResponse> {
        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder marker(String var1);
    }
}

