/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceGroupDetail;
import software.amazon.awssdk.services.emr.model.InstanceGroupDetailListCopier;
import software.amazon.awssdk.services.emr.model.PlacementType;
import software.amazon.awssdk.services.emr.transform.JobFlowInstancesDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobFlowInstancesDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, JobFlowInstancesDetail> {
    private final String masterInstanceType;
    private final String masterPublicDnsName;
    private final String masterInstanceId;
    private final String slaveInstanceType;
    private final Integer instanceCount;
    private final List<InstanceGroupDetail> instanceGroups;
    private final Integer normalizedInstanceHours;
    private final String ec2KeyName;
    private final String ec2SubnetId;
    private final PlacementType placement;
    private final Boolean keepJobFlowAliveWhenNoSteps;
    private final Boolean terminationProtected;
    private final String hadoopVersion;

    private JobFlowInstancesDetail(BuilderImpl builder) {
        this.masterInstanceType = builder.masterInstanceType;
        this.masterPublicDnsName = builder.masterPublicDnsName;
        this.masterInstanceId = builder.masterInstanceId;
        this.slaveInstanceType = builder.slaveInstanceType;
        this.instanceCount = builder.instanceCount;
        this.instanceGroups = builder.instanceGroups;
        this.normalizedInstanceHours = builder.normalizedInstanceHours;
        this.ec2KeyName = builder.ec2KeyName;
        this.ec2SubnetId = builder.ec2SubnetId;
        this.placement = builder.placement;
        this.keepJobFlowAliveWhenNoSteps = builder.keepJobFlowAliveWhenNoSteps;
        this.terminationProtected = builder.terminationProtected;
        this.hadoopVersion = builder.hadoopVersion;
    }

    public String masterInstanceType() {
        return this.masterInstanceType;
    }

    public String masterPublicDnsName() {
        return this.masterPublicDnsName;
    }

    public String masterInstanceId() {
        return this.masterInstanceId;
    }

    public String slaveInstanceType() {
        return this.slaveInstanceType;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public List<InstanceGroupDetail> instanceGroups() {
        return this.instanceGroups;
    }

    public Integer normalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public String ec2KeyName() {
        return this.ec2KeyName;
    }

    public String ec2SubnetId() {
        return this.ec2SubnetId;
    }

    public PlacementType placement() {
        return this.placement;
    }

    public Boolean keepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public Boolean terminationProtected() {
        return this.terminationProtected;
    }

    public String hadoopVersion() {
        return this.hadoopVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.masterInstanceType() == null ? 0 : this.masterInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.masterPublicDnsName() == null ? 0 : this.masterPublicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.masterInstanceId() == null ? 0 : this.masterInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.slaveInstanceType() == null ? 0 : this.slaveInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.instanceGroups() == null ? 0 : this.instanceGroups().hashCode());
        hashCode = 31 * hashCode + (this.normalizedInstanceHours() == null ? 0 : this.normalizedInstanceHours().hashCode());
        hashCode = 31 * hashCode + (this.ec2KeyName() == null ? 0 : this.ec2KeyName().hashCode());
        hashCode = 31 * hashCode + (this.ec2SubnetId() == null ? 0 : this.ec2SubnetId().hashCode());
        hashCode = 31 * hashCode + (this.placement() == null ? 0 : this.placement().hashCode());
        hashCode = 31 * hashCode + (this.keepJobFlowAliveWhenNoSteps() == null ? 0 : this.keepJobFlowAliveWhenNoSteps().hashCode());
        hashCode = 31 * hashCode + (this.terminationProtected() == null ? 0 : this.terminationProtected().hashCode());
        hashCode = 31 * hashCode + (this.hadoopVersion() == null ? 0 : this.hadoopVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowInstancesDetail)) {
            return false;
        }
        JobFlowInstancesDetail other = (JobFlowInstancesDetail)obj;
        if (other.masterInstanceType() == null ^ this.masterInstanceType() == null) {
            return false;
        }
        if (other.masterInstanceType() != null && !other.masterInstanceType().equals(this.masterInstanceType())) {
            return false;
        }
        if (other.masterPublicDnsName() == null ^ this.masterPublicDnsName() == null) {
            return false;
        }
        if (other.masterPublicDnsName() != null && !other.masterPublicDnsName().equals(this.masterPublicDnsName())) {
            return false;
        }
        if (other.masterInstanceId() == null ^ this.masterInstanceId() == null) {
            return false;
        }
        if (other.masterInstanceId() != null && !other.masterInstanceId().equals(this.masterInstanceId())) {
            return false;
        }
        if (other.slaveInstanceType() == null ^ this.slaveInstanceType() == null) {
            return false;
        }
        if (other.slaveInstanceType() != null && !other.slaveInstanceType().equals(this.slaveInstanceType())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.instanceGroups() == null ^ this.instanceGroups() == null) {
            return false;
        }
        if (other.instanceGroups() != null && !other.instanceGroups().equals(this.instanceGroups())) {
            return false;
        }
        if (other.normalizedInstanceHours() == null ^ this.normalizedInstanceHours() == null) {
            return false;
        }
        if (other.normalizedInstanceHours() != null && !other.normalizedInstanceHours().equals(this.normalizedInstanceHours())) {
            return false;
        }
        if (other.ec2KeyName() == null ^ this.ec2KeyName() == null) {
            return false;
        }
        if (other.ec2KeyName() != null && !other.ec2KeyName().equals(this.ec2KeyName())) {
            return false;
        }
        if (other.ec2SubnetId() == null ^ this.ec2SubnetId() == null) {
            return false;
        }
        if (other.ec2SubnetId() != null && !other.ec2SubnetId().equals(this.ec2SubnetId())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.keepJobFlowAliveWhenNoSteps() == null ^ this.keepJobFlowAliveWhenNoSteps() == null) {
            return false;
        }
        if (other.keepJobFlowAliveWhenNoSteps() != null && !other.keepJobFlowAliveWhenNoSteps().equals(this.keepJobFlowAliveWhenNoSteps())) {
            return false;
        }
        if (other.terminationProtected() == null ^ this.terminationProtected() == null) {
            return false;
        }
        if (other.terminationProtected() != null && !other.terminationProtected().equals(this.terminationProtected())) {
            return false;
        }
        if (other.hadoopVersion() == null ^ this.hadoopVersion() == null) {
            return false;
        }
        return other.hadoopVersion() == null || other.hadoopVersion().equals(this.hadoopVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.masterInstanceType() != null) {
            sb.append("MasterInstanceType: ").append(this.masterInstanceType()).append(",");
        }
        if (this.masterPublicDnsName() != null) {
            sb.append("MasterPublicDnsName: ").append(this.masterPublicDnsName()).append(",");
        }
        if (this.masterInstanceId() != null) {
            sb.append("MasterInstanceId: ").append(this.masterInstanceId()).append(",");
        }
        if (this.slaveInstanceType() != null) {
            sb.append("SlaveInstanceType: ").append(this.slaveInstanceType()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.instanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.instanceGroups()).append(",");
        }
        if (this.normalizedInstanceHours() != null) {
            sb.append("NormalizedInstanceHours: ").append(this.normalizedInstanceHours()).append(",");
        }
        if (this.ec2KeyName() != null) {
            sb.append("Ec2KeyName: ").append(this.ec2KeyName()).append(",");
        }
        if (this.ec2SubnetId() != null) {
            sb.append("Ec2SubnetId: ").append(this.ec2SubnetId()).append(",");
        }
        if (this.placement() != null) {
            sb.append("Placement: ").append(this.placement()).append(",");
        }
        if (this.keepJobFlowAliveWhenNoSteps() != null) {
            sb.append("KeepJobFlowAliveWhenNoSteps: ").append(this.keepJobFlowAliveWhenNoSteps()).append(",");
        }
        if (this.terminationProtected() != null) {
            sb.append("TerminationProtected: ").append(this.terminationProtected()).append(",");
        }
        if (this.hadoopVersion() != null) {
            sb.append("HadoopVersion: ").append(this.hadoopVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobFlowInstancesDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String masterInstanceType;
        private String masterPublicDnsName;
        private String masterInstanceId;
        private String slaveInstanceType;
        private Integer instanceCount;
        private List<InstanceGroupDetail> instanceGroups;
        private Integer normalizedInstanceHours;
        private String ec2KeyName;
        private String ec2SubnetId;
        private PlacementType placement;
        private Boolean keepJobFlowAliveWhenNoSteps;
        private Boolean terminationProtected;
        private String hadoopVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobFlowInstancesDetail model) {
            this.setMasterInstanceType(model.masterInstanceType);
            this.setMasterPublicDnsName(model.masterPublicDnsName);
            this.setMasterInstanceId(model.masterInstanceId);
            this.setSlaveInstanceType(model.slaveInstanceType);
            this.setInstanceCount(model.instanceCount);
            this.setInstanceGroups(model.instanceGroups);
            this.setNormalizedInstanceHours(model.normalizedInstanceHours);
            this.setEc2KeyName(model.ec2KeyName);
            this.setEc2SubnetId(model.ec2SubnetId);
            this.setPlacement(model.placement);
            this.setKeepJobFlowAliveWhenNoSteps(model.keepJobFlowAliveWhenNoSteps);
            this.setTerminationProtected(model.terminationProtected);
            this.setHadoopVersion(model.hadoopVersion);
        }

        public final String getMasterInstanceType() {
            return this.masterInstanceType;
        }

        @Override
        public final Builder masterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
            return this;
        }

        public final void setMasterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
        }

        public final String getMasterPublicDnsName() {
            return this.masterPublicDnsName;
        }

        @Override
        public final Builder masterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
            return this;
        }

        public final void setMasterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
        }

        public final String getMasterInstanceId() {
            return this.masterInstanceId;
        }

        @Override
        public final Builder masterInstanceId(String masterInstanceId) {
            this.masterInstanceId = masterInstanceId;
            return this;
        }

        public final void setMasterInstanceId(String masterInstanceId) {
            this.masterInstanceId = masterInstanceId;
        }

        public final String getSlaveInstanceType() {
            return this.slaveInstanceType;
        }

        @Override
        public final Builder slaveInstanceType(String slaveInstanceType) {
            this.slaveInstanceType = slaveInstanceType;
            return this;
        }

        public final void setSlaveInstanceType(String slaveInstanceType) {
            this.slaveInstanceType = slaveInstanceType;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<InstanceGroupDetail> getInstanceGroups() {
            return this.instanceGroups;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupDetail> instanceGroups) {
            this.instanceGroups = InstanceGroupDetailListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupDetail ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupDetail> instanceGroups) {
            this.instanceGroups = InstanceGroupDetailListCopier.copy(instanceGroups);
        }

        public final Integer getNormalizedInstanceHours() {
            return this.normalizedInstanceHours;
        }

        @Override
        public final Builder normalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
            return this;
        }

        public final void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
        }

        public final String getEc2KeyName() {
            return this.ec2KeyName;
        }

        @Override
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        public final String getEc2SubnetId() {
            return this.ec2SubnetId;
        }

        @Override
        public final Builder ec2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
            return this;
        }

        public final void setEc2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
        }

        public final PlacementType getPlacement() {
            return this.placement;
        }

        @Override
        public final Builder placement(PlacementType placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(PlacementType placement) {
            this.placement = placement;
        }

        public final Boolean getKeepJobFlowAliveWhenNoSteps() {
            return this.keepJobFlowAliveWhenNoSteps;
        }

        @Override
        public final Builder keepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
            return this;
        }

        public final void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
        }

        public final Boolean getTerminationProtected() {
            return this.terminationProtected;
        }

        @Override
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        public final String getHadoopVersion() {
            return this.hadoopVersion;
        }

        @Override
        public final Builder hadoopVersion(String hadoopVersion) {
            this.hadoopVersion = hadoopVersion;
            return this;
        }

        public final void setHadoopVersion(String hadoopVersion) {
            this.hadoopVersion = hadoopVersion;
        }

        public JobFlowInstancesDetail build() {
            return new JobFlowInstancesDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobFlowInstancesDetail> {
        public Builder masterInstanceType(String var1);

        public Builder masterPublicDnsName(String var1);

        public Builder masterInstanceId(String var1);

        public Builder slaveInstanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceGroups(Collection<InstanceGroupDetail> var1);

        public Builder instanceGroups(InstanceGroupDetail ... var1);

        public Builder normalizedInstanceHours(Integer var1);

        public Builder ec2KeyName(String var1);

        public Builder ec2SubnetId(String var1);

        public Builder placement(PlacementType var1);

        public Builder keepJobFlowAliveWhenNoSteps(Boolean var1);

        public Builder terminationProtected(Boolean var1);

        public Builder hadoopVersion(String var1);
    }
}

