/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceState;
import software.amazon.awssdk.services.emr.model.InstanceStateChangeReason;
import software.amazon.awssdk.services.emr.model.InstanceTimeline;
import software.amazon.awssdk.services.emr.transform.InstanceStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceStatus> {
    private final String state;
    private final InstanceStateChangeReason stateChangeReason;
    private final InstanceTimeline timeline;

    private InstanceStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    public String state() {
        return this.state;
    }

    public InstanceStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public InstanceTimeline timeline() {
        return this.timeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.stateChangeReason() == null ? 0 : this.stateChangeReason().hashCode());
        hashCode = 31 * hashCode + (this.timeline() == null ? 0 : this.timeline().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus)obj;
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.stateChangeReason() == null ^ this.stateChangeReason() == null) {
            return false;
        }
        if (other.stateChangeReason() != null && !other.stateChangeReason().equals(this.stateChangeReason())) {
            return false;
        }
        if (other.timeline() == null ^ this.timeline() == null) {
            return false;
        }
        return other.timeline() == null || other.timeline().equals(this.timeline());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.stateChangeReason()).append(",");
        }
        if (this.timeline() != null) {
            sb.append("Timeline: ").append(this.timeline()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String state;
        private InstanceStateChangeReason stateChangeReason;
        private InstanceTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatus model) {
            this.setState(model.state);
            this.setStateChangeReason(model.stateChangeReason);
            this.setTimeline(model.timeline);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final InstanceStateChangeReason getStateChangeReason() {
            return this.stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(InstanceStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(InstanceStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        public final InstanceTimeline getTimeline() {
            return this.timeline;
        }

        @Override
        public final Builder timeline(InstanceTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(InstanceTimeline timeline) {
            this.timeline = timeline;
        }

        public InstanceStatus build() {
            return new InstanceStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceStatus> {
        public Builder state(String var1);

        public Builder state(InstanceState var1);

        public Builder stateChangeReason(InstanceStateChangeReason var1);

        public Builder timeline(InstanceTimeline var1);
    }
}

