/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ComparisonOperator;
import software.amazon.awssdk.services.emr.model.MetricDimension;
import software.amazon.awssdk.services.emr.model.MetricDimensionListCopier;
import software.amazon.awssdk.services.emr.model.Statistic;
import software.amazon.awssdk.services.emr.model.Unit;
import software.amazon.awssdk.services.emr.transform.CloudWatchAlarmDefinitionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchAlarmDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchAlarmDefinition> {
    private final String comparisonOperator;
    private final Integer evaluationPeriods;
    private final String metricName;
    private final String namespace;
    private final Integer period;
    private final String statistic;
    private final Double threshold;
    private final String unit;
    private final List<MetricDimension> dimensions;

    private CloudWatchAlarmDefinition(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.period = builder.period;
        this.statistic = builder.statistic;
        this.threshold = builder.threshold;
        this.unit = builder.unit;
        this.dimensions = builder.dimensions;
    }

    public String comparisonOperator() {
        return this.comparisonOperator;
    }

    public Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public Integer period() {
        return this.period;
    }

    public String statistic() {
        return this.statistic;
    }

    public Double threshold() {
        return this.threshold;
    }

    public String unit() {
        return this.unit;
    }

    public List<MetricDimension> dimensions() {
        return this.dimensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.comparisonOperator() == null ? 0 : this.comparisonOperator().hashCode());
        hashCode = 31 * hashCode + (this.evaluationPeriods() == null ? 0 : this.evaluationPeriods().hashCode());
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.namespace() == null ? 0 : this.namespace().hashCode());
        hashCode = 31 * hashCode + (this.period() == null ? 0 : this.period().hashCode());
        hashCode = 31 * hashCode + (this.statistic() == null ? 0 : this.statistic().hashCode());
        hashCode = 31 * hashCode + (this.threshold() == null ? 0 : this.threshold().hashCode());
        hashCode = 31 * hashCode + (this.unit() == null ? 0 : this.unit().hashCode());
        hashCode = 31 * hashCode + (this.dimensions() == null ? 0 : this.dimensions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchAlarmDefinition)) {
            return false;
        }
        CloudWatchAlarmDefinition other = (CloudWatchAlarmDefinition)obj;
        if (other.comparisonOperator() == null ^ this.comparisonOperator() == null) {
            return false;
        }
        if (other.comparisonOperator() != null && !other.comparisonOperator().equals(this.comparisonOperator())) {
            return false;
        }
        if (other.evaluationPeriods() == null ^ this.evaluationPeriods() == null) {
            return false;
        }
        if (other.evaluationPeriods() != null && !other.evaluationPeriods().equals(this.evaluationPeriods())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.statistic() == null ^ this.statistic() == null) {
            return false;
        }
        if (other.statistic() != null && !other.statistic().equals(this.statistic())) {
            return false;
        }
        if (other.threshold() == null ^ this.threshold() == null) {
            return false;
        }
        if (other.threshold() != null && !other.threshold().equals(this.threshold())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        if (other.unit() != null && !other.unit().equals(this.unit())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        return other.dimensions() == null || other.dimensions().equals(this.dimensions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.comparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperator()).append(",");
        }
        if (this.evaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(this.evaluationPeriods()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.period() != null) {
            sb.append("Period: ").append(this.period()).append(",");
        }
        if (this.statistic() != null) {
            sb.append("Statistic: ").append(this.statistic()).append(",");
        }
        if (this.threshold() != null) {
            sb.append("Threshold: ").append(this.threshold()).append(",");
        }
        if (this.unit() != null) {
            sb.append("Unit: ").append(this.unit()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchAlarmDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String comparisonOperator;
        private Integer evaluationPeriods;
        private String metricName;
        private String namespace;
        private Integer period;
        private String statistic;
        private Double threshold;
        private String unit;
        private List<MetricDimension> dimensions;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchAlarmDefinition model) {
            this.setComparisonOperator(model.comparisonOperator);
            this.setEvaluationPeriods(model.evaluationPeriods);
            this.setMetricName(model.metricName);
            this.setNamespace(model.namespace);
            this.setPeriod(model.period);
            this.setStatistic(model.statistic);
            this.setThreshold(model.threshold);
            this.setUnit(model.unit);
            this.setDimensions(model.dimensions);
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Collection<MetricDimension> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final Builder dimensions(Collection<MetricDimension> dimensions) {
            this.dimensions = MetricDimensionListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(MetricDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<MetricDimension> dimensions) {
            this.dimensions = MetricDimensionListCopier.copy(dimensions);
        }

        public CloudWatchAlarmDefinition build() {
            return new CloudWatchAlarmDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchAlarmDefinition> {
        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder period(Integer var1);

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder threshold(Double var1);

        public Builder unit(String var1);

        public Builder unit(Unit var1);

        public Builder dimensions(Collection<MetricDimension> var1);

        public Builder dimensions(MetricDimension ... var1);
    }
}

