/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.ClusterTimeline;

@SdkInternalApi
public class ClusterTimelineMarshaller {
    private static final MarshallingInfo<Instant> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").build();
    private static final MarshallingInfo<Instant> READYDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadyDateTime").build();
    private static final MarshallingInfo<Instant> ENDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndDateTime").build();
    private static final ClusterTimelineMarshaller instance = new ClusterTimelineMarshaller();

    public static ClusterTimelineMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClusterTimeline clusterTimeline, ProtocolMarshaller protocolMarshaller) {
        if (clusterTimeline == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)clusterTimeline.creationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)clusterTimeline.readyDateTime(), READYDATETIME_BINDING);
            protocolMarshaller.marshall((Object)clusterTimeline.endDateTime(), ENDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

