/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.transform.ScalingConstraintsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScalingConstraints
implements StructuredPojo,
ToCopyableBuilder<Builder, ScalingConstraints> {
    private final Integer minCapacity;
    private final Integer maxCapacity;

    private ScalingConstraints(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
    }

    public Integer minCapacity() {
        return this.minCapacity;
    }

    public Integer maxCapacity() {
        return this.maxCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.minCapacity() == null ? 0 : this.minCapacity().hashCode());
        hashCode = 31 * hashCode + (this.maxCapacity() == null ? 0 : this.maxCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConstraints)) {
            return false;
        }
        ScalingConstraints other = (ScalingConstraints)obj;
        if (other.minCapacity() == null ^ this.minCapacity() == null) {
            return false;
        }
        if (other.minCapacity() != null && !other.minCapacity().equals(this.minCapacity())) {
            return false;
        }
        if (other.maxCapacity() == null ^ this.maxCapacity() == null) {
            return false;
        }
        return other.maxCapacity() == null || other.maxCapacity().equals(this.maxCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minCapacity() != null) {
            sb.append("MinCapacity: ").append(this.minCapacity()).append(",");
        }
        if (this.maxCapacity() != null) {
            sb.append("MaxCapacity: ").append(this.maxCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingConstraintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer minCapacity;
        private Integer maxCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConstraints model) {
            this.setMinCapacity(model.minCapacity);
            this.setMaxCapacity(model.maxCapacity);
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public ScalingConstraints build() {
            return new ScalingConstraints(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingConstraints> {
        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);
    }
}

