/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.VolumeSpecification;
import software.amazon.awssdk.services.emr.transform.EbsBlockDeviceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EbsBlockDevice
implements StructuredPojo,
ToCopyableBuilder<Builder, EbsBlockDevice> {
    private final VolumeSpecification volumeSpecification;
    private final String device;

    private EbsBlockDevice(BuilderImpl builder) {
        this.volumeSpecification = builder.volumeSpecification;
        this.device = builder.device;
    }

    public VolumeSpecification volumeSpecification() {
        return this.volumeSpecification;
    }

    public String device() {
        return this.device;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.volumeSpecification() == null ? 0 : this.volumeSpecification().hashCode());
        hashCode = 31 * hashCode + (this.device() == null ? 0 : this.device().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice)obj;
        if (other.volumeSpecification() == null ^ this.volumeSpecification() == null) {
            return false;
        }
        if (other.volumeSpecification() != null && !other.volumeSpecification().equals(this.volumeSpecification())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        return other.device() == null || other.device().equals(this.device());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumeSpecification() != null) {
            sb.append("VolumeSpecification: ").append(this.volumeSpecification()).append(",");
        }
        if (this.device() != null) {
            sb.append("Device: ").append(this.device()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EbsBlockDeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private VolumeSpecification volumeSpecification;
        private String device;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            this.setVolumeSpecification(model.volumeSpecification);
            this.setDevice(model.device);
        }

        public final VolumeSpecification getVolumeSpecification() {
            return this.volumeSpecification;
        }

        @Override
        public final Builder volumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
            return this;
        }

        public final void setVolumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsBlockDevice> {
        public Builder volumeSpecification(VolumeSpecification var1);

        public Builder device(String var1);
    }
}

