/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.services.emr.transform.CommandMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Command
implements StructuredPojo,
ToCopyableBuilder<Builder, Command> {
    private final String name;
    private final String scriptPath;
    private final List<String> args;

    private Command(BuilderImpl builder) {
        this.name = builder.name;
        this.scriptPath = builder.scriptPath;
        this.args = builder.args;
    }

    public String name() {
        return this.name;
    }

    public String scriptPath() {
        return this.scriptPath;
    }

    public List<String> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.scriptPath() == null ? 0 : this.scriptPath().hashCode());
        hashCode = 31 * hashCode + (this.args() == null ? 0 : this.args().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.scriptPath() == null ^ this.scriptPath() == null) {
            return false;
        }
        if (other.scriptPath() != null && !other.scriptPath().equals(this.scriptPath())) {
            return false;
        }
        if (other.args() == null ^ this.args() == null) {
            return false;
        }
        return other.args() == null || other.args().equals(this.args());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.scriptPath() != null) {
            sb.append("ScriptPath: ").append(this.scriptPath()).append(",");
        }
        if (this.args() != null) {
            sb.append("Args: ").append(this.args()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String scriptPath;
        private List<String> args;

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            this.setName(model.name);
            this.setScriptPath(model.scriptPath);
            this.setArgs(model.args);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getScriptPath() {
            return this.scriptPath;
        }

        @Override
        public final Builder scriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
            return this;
        }

        public final void setScriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        public final Collection<String> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = StringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = StringListCopier.copy(args);
        }

        @SafeVarargs
        public final void setArgs(String ... args) {
            this.args(Arrays.asList(args));
        }

        public Command build() {
            return new Command(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Command> {
        public Builder name(String var1);

        public Builder scriptPath(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);
    }
}

