/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyState;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason;
import software.amazon.awssdk.services.emr.transform.AutoScalingPolicyStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutoScalingPolicyStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingPolicyStatus> {
    private final String state;
    private final AutoScalingPolicyStateChangeReason stateChangeReason;

    private AutoScalingPolicyStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
    }

    public String state() {
        return this.state;
    }

    public AutoScalingPolicyStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.stateChangeReason() == null ? 0 : this.stateChangeReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyStatus)) {
            return false;
        }
        AutoScalingPolicyStatus other = (AutoScalingPolicyStatus)obj;
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.stateChangeReason() == null ^ this.stateChangeReason() == null) {
            return false;
        }
        return other.stateChangeReason() == null || other.stateChangeReason().equals(this.stateChangeReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.stateChangeReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingPolicyStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String state;
        private AutoScalingPolicyStateChangeReason stateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyStatus model) {
            this.setState(model.state);
            this.setStateChangeReason(model.stateChangeReason);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AutoScalingPolicyState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(AutoScalingPolicyState state) {
            this.state(state.toString());
        }

        public final AutoScalingPolicyStateChangeReason getStateChangeReason() {
            return this.stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(AutoScalingPolicyStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(AutoScalingPolicyStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        public AutoScalingPolicyStatus build() {
            return new AutoScalingPolicyStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingPolicyStatus> {
        public Builder state(String var1);

        public Builder state(AutoScalingPolicyState var1);

        public Builder stateChangeReason(AutoScalingPolicyStateChangeReason var1);
    }
}

