/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.services.emr.model.StringMapCopier;
import software.amazon.awssdk.services.emr.transform.ApplicationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Application
implements StructuredPojo,
ToCopyableBuilder<Builder, Application> {
    private final String name;
    private final String version;
    private final List<String> args;
    private final Map<String, String> additionalInfo;

    private Application(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.args = builder.args;
        this.additionalInfo = builder.additionalInfo;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public List<String> args() {
        return this.args;
    }

    public Map<String, String> additionalInfo() {
        return this.additionalInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.args() == null ? 0 : this.args().hashCode());
        hashCode = 31 * hashCode + (this.additionalInfo() == null ? 0 : this.additionalInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.args() == null ^ this.args() == null) {
            return false;
        }
        if (other.args() != null && !other.args().equals(this.args())) {
            return false;
        }
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        return other.additionalInfo() == null || other.additionalInfo().equals(this.additionalInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.args() != null) {
            sb.append("Args: ").append(this.args()).append(",");
        }
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private List<String> args;
        private Map<String, String> additionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            this.setName(model.name);
            this.setVersion(model.version);
            this.setArgs(model.args);
            this.setAdditionalInfo(model.additionalInfo);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<String> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = StringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = StringListCopier.copy(args);
        }

        @SafeVarargs
        public final void setArgs(String ... args) {
            this.args(Arrays.asList(args));
        }

        public final Map<String, String> getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = StringMapCopier.copy(additionalInfo);
            return this;
        }

        public final void setAdditionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = StringMapCopier.copy(additionalInfo);
        }

        public Application build() {
            return new Application(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Application> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);

        public Builder additionalInfo(Map<String, String> var1);
    }
}

