/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfig;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfigListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddInstanceGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddInstanceGroupsRequest> {
    private final List<InstanceGroupConfig> instanceGroups;
    private final String jobFlowId;

    private AddInstanceGroupsRequest(BuilderImpl builder) {
        this.instanceGroups = builder.instanceGroups;
        this.jobFlowId = builder.jobFlowId;
    }

    public List<InstanceGroupConfig> instanceGroups() {
        return this.instanceGroups;
    }

    public String jobFlowId() {
        return this.jobFlowId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceGroups() == null ? 0 : this.instanceGroups().hashCode());
        hashCode = 31 * hashCode + (this.jobFlowId() == null ? 0 : this.jobFlowId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsRequest)) {
            return false;
        }
        AddInstanceGroupsRequest other = (AddInstanceGroupsRequest)((Object)obj);
        if (other.instanceGroups() == null ^ this.instanceGroups() == null) {
            return false;
        }
        if (other.instanceGroups() != null && !other.instanceGroups().equals(this.instanceGroups())) {
            return false;
        }
        if (other.jobFlowId() == null ^ this.jobFlowId() == null) {
            return false;
        }
        return other.jobFlowId() == null || other.jobFlowId().equals(this.jobFlowId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.instanceGroups()).append(",");
        }
        if (this.jobFlowId() != null) {
            sb.append("JobFlowId: ").append(this.jobFlowId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceGroupConfig> instanceGroups;
        private String jobFlowId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceGroupsRequest model) {
            this.setInstanceGroups(model.instanceGroups);
            this.setJobFlowId(model.jobFlowId);
        }

        public final Collection<InstanceGroupConfig> getInstanceGroups() {
            return this.instanceGroups;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copy(instanceGroups);
        }

        @SafeVarargs
        public final void setInstanceGroups(InstanceGroupConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
        }

        public final String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        public AddInstanceGroupsRequest build() {
            return new AddInstanceGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddInstanceGroupsRequest> {
        public Builder instanceGroups(Collection<InstanceGroupConfig> var1);

        public Builder instanceGroups(InstanceGroupConfig ... var1);

        public Builder jobFlowId(String var1);
    }
}

