/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.JobFlowDetail;
import software.amazon.awssdk.services.emr.model.JobFlowDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobFlowsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, DescribeJobFlowsResponse> {
    private static final SdkField<List<JobFlowDetail>> JOB_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeJobFlowsResponse.getter(DescribeJobFlowsResponse::jobFlows)).setter(DescribeJobFlowsResponse.setter(Builder::jobFlows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobFlowDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOWS_FIELD));
    private final List<JobFlowDetail> jobFlows;

    private DescribeJobFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.jobFlows = builder.jobFlows;
    }

    public List<JobFlowDetail> jobFlows() {
        return this.jobFlows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlows());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobFlowsResponse)) {
            return false;
        }
        DescribeJobFlowsResponse other = (DescribeJobFlowsResponse)((Object)obj);
        return Objects.equals(this.jobFlows(), other.jobFlows());
    }

    public String toString() {
        return ToString.builder((String)"DescribeJobFlowsResponse").add("JobFlows", this.jobFlows()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlows": {
                return Optional.ofNullable(clazz.cast(this.jobFlows()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobFlowsResponse, T> g) {
        return obj -> g.apply((DescribeJobFlowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<JobFlowDetail> jobFlows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobFlowsResponse model) {
            super(model);
            this.jobFlows(model.jobFlows);
        }

        public final Collection<JobFlowDetail.Builder> getJobFlows() {
            return this.jobFlows != null ? (Collection)this.jobFlows.stream().map(JobFlowDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobFlows(Collection<JobFlowDetail> jobFlows) {
            this.jobFlows = JobFlowDetailListCopier.copy(jobFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlows(JobFlowDetail ... jobFlows) {
            this.jobFlows(Arrays.asList(jobFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlows(Consumer<JobFlowDetail.Builder> ... jobFlows) {
            this.jobFlows(Stream.of(jobFlows).map(c -> (JobFlowDetail)((JobFlowDetail.Builder)JobFlowDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobFlows(Collection<JobFlowDetail.BuilderImpl> jobFlows) {
            this.jobFlows = JobFlowDetailListCopier.copyFromBuilder(jobFlows);
        }

        @Override
        public DescribeJobFlowsResponse build() {
            return new DescribeJobFlowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJobFlowsResponse> {
        public Builder jobFlows(Collection<JobFlowDetail> var1);

        public Builder jobFlows(JobFlowDetail ... var1);

        public Builder jobFlows(Consumer<JobFlowDetail.Builder> ... var1);
    }
}

