/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.JobFlowExecutionState;
import software.amazon.awssdk.services.emr.model.JobFlowExecutionStateListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobFlowsRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, DescribeJobFlowsRequest> {
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeJobFlowsRequest.getter(DescribeJobFlowsRequest::createdAfter)).setter(DescribeJobFlowsRequest.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeJobFlowsRequest.getter(DescribeJobFlowsRequest::createdBefore)).setter(DescribeJobFlowsRequest.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()}).build();
    private static final SdkField<List<String>> JOB_FLOW_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeJobFlowsRequest.getter(DescribeJobFlowsRequest::jobFlowIds)).setter(DescribeJobFlowsRequest.setter(Builder::jobFlowIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> JOB_FLOW_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeJobFlowsRequest.getter(DescribeJobFlowsRequest::jobFlowStatesAsStrings)).setter(DescribeJobFlowsRequest.setter(Builder::jobFlowStatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, JOB_FLOW_IDS_FIELD, JOB_FLOW_STATES_FIELD));
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final List<String> jobFlowIds;
    private final List<String> jobFlowStates;

    private DescribeJobFlowsRequest(BuilderImpl builder) {
        super(builder);
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.jobFlowIds = builder.jobFlowIds;
        this.jobFlowStates = builder.jobFlowStates;
    }

    public Instant createdAfter() {
        return this.createdAfter;
    }

    public Instant createdBefore() {
        return this.createdBefore;
    }

    public List<String> jobFlowIds() {
        return this.jobFlowIds;
    }

    public List<JobFlowExecutionState> jobFlowStates() {
        return TypeConverter.convert(this.jobFlowStates, JobFlowExecutionState::fromValue);
    }

    public List<String> jobFlowStatesAsStrings() {
        return this.jobFlowStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowStatesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobFlowsRequest)) {
            return false;
        }
        DescribeJobFlowsRequest other = (DescribeJobFlowsRequest)((Object)obj);
        return Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.jobFlowIds(), other.jobFlowIds()) && Objects.equals(this.jobFlowStatesAsStrings(), other.jobFlowStatesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeJobFlowsRequest").add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("JobFlowIds", this.jobFlowIds()).add("JobFlowStates", this.jobFlowStatesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "JobFlowIds": {
                return Optional.ofNullable(clazz.cast(this.jobFlowIds()));
            }
            case "JobFlowStates": {
                return Optional.ofNullable(clazz.cast(this.jobFlowStatesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobFlowsRequest, T> g) {
        return obj -> g.apply((DescribeJobFlowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private Instant createdAfter;
        private Instant createdBefore;
        private List<String> jobFlowIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> jobFlowStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobFlowsRequest model) {
            super(model);
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.jobFlowIds(model.jobFlowIds);
            this.jobFlowStatesWithStrings(model.jobFlowStates);
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Collection<String> getJobFlowIds() {
            return this.jobFlowIds;
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String ... jobFlowIds) {
            this.jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        public final Collection<String> getJobFlowStates() {
            return this.jobFlowStates;
        }

        @Override
        public final Builder jobFlowStatesWithStrings(Collection<String> jobFlowStates) {
            this.jobFlowStates = JobFlowExecutionStateListCopier.copy(jobFlowStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowStatesWithStrings(String ... jobFlowStates) {
            this.jobFlowStatesWithStrings(Arrays.asList(jobFlowStates));
            return this;
        }

        @Override
        public final Builder jobFlowStates(Collection<JobFlowExecutionState> jobFlowStates) {
            this.jobFlowStates = JobFlowExecutionStateListCopier.copyEnumToString(jobFlowStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowStates(JobFlowExecutionState ... jobFlowStates) {
            this.jobFlowStates(Arrays.asList(jobFlowStates));
            return this;
        }

        public final void setJobFlowStates(Collection<String> jobFlowStates) {
            this.jobFlowStates = JobFlowExecutionStateListCopier.copy(jobFlowStates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeJobFlowsRequest build() {
            return new DescribeJobFlowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJobFlowsRequest> {
        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder jobFlowIds(Collection<String> var1);

        public Builder jobFlowIds(String ... var1);

        public Builder jobFlowStatesWithStrings(Collection<String> var1);

        public Builder jobFlowStatesWithStrings(String ... var1);

        public Builder jobFlowStates(Collection<JobFlowExecutionState> var1);

        public Builder jobFlowStates(JobFlowExecutionState ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

